// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <unistd.h>

#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include "mmap.h"

FitsMMap::FitsMMap(const char* fn)
{
  // parse the fn and options

  parse(fn);
  if (!pName_)
    return;

  // Map the file.
  int file = open(pName_, O_RDONLY);
  if (file == -1)
    return;

  struct stat info;
  if (fstat(file, &info) < 0)
    return;

  // check for at least one block
  if (info.st_size < FTY_BLOCK)
    return;

  // map it
  mapsize_ = info.st_size;
  mapdata_ = (char*)mmap(NULL, mapsize_, PROT_READ, MAP_SHARED, file, 0);

  // close the file
  close(file);

  // are we valid?
  if ((long)mapdata_ == -1)
    return;

  // so far, so good
  valid_ = 1;
}

FitsMMap::~FitsMMap()
{
  if (mapdata_>0)
    munmap((caddr_t)mapdata_, mapsize_);
}

