// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <unistd.h>
#include "allocgz.h"

FitsAllocGZ::FitsAllocGZ(const char* fn)
{
  parse(fn);

  // we need the 'b' for windows...
  if (!strcmp(pName_, "stdin") || 
      !strcmp(pName_, "STDIN") || 
      !strcmp(pName_, "-"))
    stream_ = gzdopen(dup(STDIN_FILENO), "rb");
  else 
    stream_ = gzopen(pName_, "rb");

  if (stream_)
    valid_ = 1;
}


