/* Copyright (C) 1999-2005
 * Smithsonian Astrophysical Observatory, Cambridge, MA, USA
 * For conditions of distribution and use, see copyright notice in "copyright"
 */

%option noyywrap
%option caseless
%option never-interactive
%option c++

%{
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>

  #include "parser.H"

%}

D   [0-9]
E   [Ee][+-]?{D}+

/* rules */

%%

adjust		{return ADJUST_;}
bias		{return BIAS_;}
bw		{return BW_;}
channel		{return CHANNEL_;}
colormap	{return COLORMAP_;}
colorspace	{return COLORSPACE_;}
colors          {return COLORS_;}
contrast	{return CONTRAST_;}
cmyk		{return CMYK_;}
debug		{return DEBUG_;}
get		{return GET_;}
gray		{return GRAY_;}
false		{return FALSE_;}
file		{return FILE_;}
height		{return HEIGHT_;}
hide		{return HIDE_;}
id		{return ID_;}
invert		{return INVERT_;}
itt		{return ITT_;}
level		{return LEVEL_;}
list		{return LIST_;}
load		{return LOAD_;}
map		{return MAP_;}
n		{return N_;}
name		{return NAME_;}
no		{return NO_;}
off		{return OFF_;}
on		{return ON_;}
postscript	{return POSTSCRIPT_;}
reset		{return RESET_;}
resolution	{return RESOLUTION_;}
rgb		{return RGB_;}
save		{return SAVE_;}
set		{return SET_;}
show		{return SHOW_;}
true		{return TRUE_;}
version		{return VERSION_;}
width		{return WIDTH_;}
window		{return WINDOW_;}
y		{return Y_;}
yes		{return YES_;}

[+-]?{D}+	{ // Integer
		  cblval.integer = atoi(yytext);
		  return INT;
		}

[+-]?{D}+"."?({E})? |
[+-]?{D}*"."{D}+({E})? { // Real Number
		  cblval.real = atof(yytext);
		  return REAL;
		}

\"[^\"\n]*\" | 
\'[^\'\n]*\'	{ // Quoted String
		  strncpy(cblval.str,yytext+1,yyleng-2); // skip the " " 
	          cblval.str[yyleng-2] = '\0'; // Remove the '"' 
		  return STRING;
		}

\{[^\}\n]*\} 	{ // Quoted String
		  strncpy(cblval.str,yytext+1,yyleng-2); // skip the '{'
	          cblval.str[yyleng-2] = '\0'; // Remove the '}'
		  return STRING;
		}

[!-~][!-~]+	{ // General String-- at least 2 printable chars
		  strcpy(cblval.str,yytext);
		  return STRING;
		}

[ \t]+		{ // White Spaces
		} 

.		{ // Else, return the char
		  return yytext[0];
		}

%%
