#! /bin/sh

if [ "$2" = "val" ]; then
#    CMD="valgrind --leak-check=yes --show-reachable=yes ../ds9val"
    CMD="valgrind --leak-check=yes ../ds9val"
    XPA=ds9val
else
    CMD=../ds9
    XPA=ds9
fi

echo "Alignment Tests"
echo

echo "test panner,center,zoom"
$CMD 5x5.fits
echo "PASSED"

echo "testing DATASEC"
$CMD ds9_2amp.fits
echo "PASSED"

echo "testing WCS FK5"
$CMD -zscale -mosaicimage iraf mosaicimage.fits -mosaicimage wcs mosaicimage.fits -file -rgb mosaicimage.fits[1] -green mosaicimage.fits[2] -blue mosaicimage.fits[3]
echo "PASSED"

echo "testing WCS Linear"
$CMD -mosaicimage iraf ds9_2amp.fits -mosaicimage wcs ds9_2amp.fits -file -rgb -red ds9_2amp.fits[1] -green ds9_2amp.fits[2]
echo "PASSED"

echo "testing WCS Linear block x2"
$CMD -mosaicimage iraf ds9_8amp_2x2.fits -mosaicimage wcs ds9_8amp_2x2.fits
echo "PASSED"

echo "testing WCS RGB"
$CMD -zscale -mosaic wcs m51hst.fits img-32.fits -file -rgb -red m51hst.fits -green img-32.fits
echo "PASSED"

echo "Done"


