#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc InitTemplates {} {
    global marker
    global template

    # chandra
    # acis-i
    set template(chandra,acis,acis-i) {chandra/acis/acis-i.tpl}
    set template(chandra,acis,acis-i-letg) {chandra/acis/acis-i-letg.tpl}
    set template(chandra,acis,acis-i-hetg) {chandra/acis/acis-i-hetg.tpl}

    # acis-s
    set template(chandra,acis,acis-s) {chandra/acis/acis-s.tpl}
    set template(chandra,acis,acis-s-letg) {chandra/acis/acis-s-letg.tpl}
    set template(chandra,acis,acis-s-hetg) {chandra/acis/acis-s-hetg.tpl}

    # acis-is
    set template(chandra,acis,acis-is) {chandra/acis/acis-is.tpl}
    set template(chandra,acis,acis-is-letg) {chandra/acis/acis-is-letg.tpl}
    set template(chandra,acis,acis-is-hetg) {chandra/acis/acis-is-hetg.tpl}

    # acis-si
    set template(chandra,acis,acis-si) {chandra/acis/acis-si.tpl}
    set template(chandra,acis,acis-si-letg) {chandra/acis/acis-si-letg.tpl}
    set template(chandra,acis,acis-si-hetg) {chandra/acis/acis-si-hetg.tpl}

    # acis-is2
    set template(chandra,acis,acis-is2) {chandra/acis/acis-is2.tpl}
    set template(chandra,acis,acis-is2-letg) {chandra/acis/acis-is2-letg.tpl}
    set template(chandra,acis,acis-is2-hetg) {chandra/acis/acis-is2-hetg.tpl}

    # hrc-i
    set template(chandra,hrc,hrc-i) {chandra/hrc/hrc-i.tpl}
    set template(chandra,hrc,hrc-i-letg) {chandra/hrc/hrc-i-letg.tpl}
    set template(chandra,hrc,hrc-i-hetg) {chandra/hrc/hrc-i-hetg.tpl}

    # hrc-s
    set template(chandra,hrc,hrc-s) {chandra/hrc/hrc-s.tpl}
    set template(chandra,hrc,hrc-s-letg) {chandra/hrc/hrc-s-letg.tpl}
    set template(chandra,hrc,hrc-s-hetg) {chandra/hrc/hrc-s-hetg.tpl}

    # xmm

    set template(xmm,epicmos1) {xmm/epicmos1.tpl}
    set template(xmm,epicmos2) {xmm/epicmos2.tpl}
    set template(xmm,epicpn) {xmm/epicpn.tpl}

    # sao
    set template(sao,megacam-amp) {sao/megacam-amp.tpl}
    set template(sao,megacam-chip) {sao/megacam-chip.tpl}
    set template(sao,swirc) {sao/swirc.tpl}
    set template(sao,hectospec) {sao/hectospec.tpl}
    set template(sao,hectochelle) {sao/hectochelle.tpl}
}

proc CreateTemplateMenu {} {
    global ds9
    global menu
    global template
    global marker

    menu $ds9(mb).region.shape.template -tearoff $menu(tearoff) \
	-selectcolor $menu(selectcolor) -title "DS9 Region Shape Template"

    set l0 {}
    set l1 {}
    set l2 {}

    foreach t [lsort [array names template]] {
	set tt [split $t ","]
	set t0 [lindex $tt 0]
	set t1 [lindex $tt 1]
	set t2 [lindex $tt 2]

	if {$l0 != $t0} {
	    menu $ds9(mb).region.shape.template.$t0 \
		-tearoff $menu(tearoff) -selectcolor $menu(selectcolor)
	    $ds9(mb).region.shape.template add cascade \
		-label [string toupper $t0] \
		-menu $ds9(mb).region.shape.template.$t0
	    set l0 $t0
	    set l1 {}
	    set l2 {}
	}

	if {$l1 != $t1} {
	    if {$t2 != {}} {
		menu $ds9(mb).region.shape.template.$t0.$t1 \
		    -tearoff $menu(tearoff) -selectcolor $menu(selectcolor)
		$ds9(mb).region.shape.template.$t0 add cascade \
		    -label [string toupper $t1] \
		    -menu $ds9(mb).region.shape.template.$t0.$t1
		set l1 $t1
		set l2 {}
	    } else {
		$ds9(mb).region.shape.template.$t0 add radiobutton \
		    -label [string toupper $t1] -variable marker(shape) \
		    -value $t
		continue
	    }
	}

	set tt2 [split $t2 "-"]
	set s0 [lindex $tt2 0]
	set s1 [lindex $tt2 1]

	if {$l2 != $s1} {
	    if {$l2 != {}} {
		$ds9(mb).region.shape.template.$t0.$t1 add separator
	    }
	    set l2 $s1
	}

	$ds9(mb).region.shape.template.$t0.$t1 add radiobutton \
	    -label [string toupper $t2] -variable marker(shape) -value $t
    }
}

proc OpenTemplateMarker {} {
    LoadTemplateMarker [OpenFileDialog templatefbox]
}

proc LoadTemplateMarker {fn} {
    global ds9
    global current

    if {$current(frame) != {}} {
	if {$fn != {}} {
	    SetWatchCursor
	    set cc [$ds9(canvas) coords $current(frame)]
	    catch {$current(frame) marker create template \
		       [lindex $cc 0] [lindex $cc 1] "\{$fn\}"}
	    UnsetWatchCursor
	}
    }
}

proc SaveAsTemplateMarker {} {
    global current

    if {$current(frame) != {}} {
	SetWatchCursor
	set fn [SaveFileDialog templatefbox]

	if {$fn != {}} {
	    $current(frame) marker save template "\{$fn\}"
	}
	UnsetWatchCursor
    }
}
