#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc NRESDialog {} {
    set varname nres
    upvar #0 $varname var

    global ds9
    global menu

    if [winfo exists $var(top)] {
	raise $var(top)
	return
    }

    # AR variables
    set var(status) {}
    set var(current) {}
    set var(sync) 0

    set var(proc,next) NRESDone

    # top
    set w $var(top)
    set title "Name Resolution"

    # create the window
    toplevel $w -colormap $ds9(main)
    wm title $w $title
    wm iconname $w $title
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW "ARDestroy $varname"

    # menu
    $w configure -menu $var(mb)
    menu $var(mb) -tearoff 0

    # file
    $var(mb) add cascade -label File -menu $var(mb).file
    menu $var(mb).file -tearoff 0 -selectcolor $menu(selectcolor)
    $var(mb).file add command -label Retrieve -command "NRESApply $varname 0"
    $var(mb).file add command -label Cancel -command "ARCancel $varname"
    $var(mb).file add separator
    $var(mb).file add command -label "Pan To" -command "NRESPan $varname"
    $var(mb).file add command -label "Crosshair To" \
	-command "NRESCrosshair $varname"
    $var(mb).file add separator
    $var(mb).file add command -label Close -command "ARDestroy $varname"

    # edit
    AREditMenu nres

    # name server
    NSVRServerMenu nres

    # name format
    $var(mb) add cascade -label Format -menu $var(mb).format
    menu $var(mb).format -tearoff 0 -selectcolor $menu(selectcolor)
    $var(mb).format add radiobutton -label "Degrees" \
	-variable ${varname}(skyformat) -value degrees
    $var(mb).format add radiobutton -label "Sexagesimal" \
	-variable ${varname}(skyformat) -value sexagesimal

    # dialog
    frame $w.param -relief groove -borderwidth 2
    frame $w.status -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.param $w.status $w.buttons -fill x -expand true -ipadx 4 -ipady 4

    label $w.param.nametitle -text Name
    entry $w.param.name -textvariable ${varname}(name) -width 32

    set var(xname) [label $w.param.xtitle -text "" -font {symbol 12} -width 1]
    label $w.param.x -textvariable ${varname}(x) -width 14 -relief groove
    set var(yname) [label $w.param.ytitle -text "" -font {symbol 12} -width 1]
    label $w.param.y -textvariable ${varname}(y) -width 14 -relief groove
    label $w.param.system -textvariable ${varname}(sky) \
	-width 10 -relief groove

    grid rowconfigure $w.param 0 -pad 4
    grid rowconfigure $w.param 1 -pad 4

    grid $w.param.nametitle $w.param.name - - -padx 4 -pady 1 -sticky w
    grid $w.param.xtitle $w.param.x $w.param.ytitle $w.param.y \
	$w.param.system -padx 4 -pady 1 -sticky w

    label $w.status.item -textvariable ${varname}(status)
    pack $w.status.item -anchor w -pady 4

    set var(apply) [button $w.buttons.apply -text Retrieve \
			-command "NRESApply $varname 0"]
    set var(cancel) [button $w.buttons.cancel -text Cancel \
			 -command "ARCancel  $varname" -state disabled]

    button $w.buttons.close -text "Close" -command "ARDestroy $varname"
    pack $w.buttons.apply $w.buttons.cancel $w.buttons.close \
	-side left -padx 10 -expand true

    ARCoord $varname
    ARStatus $varname {}
}

proc NRESApply {varname sync} {
    upvar #0 $varname var

    set var(sync) $sync

    ARStatus $varname {}

    $var(mb).file entryconfig Retrieve -state disabled
    $var(mb).file entryconfig Cancel -state normal

    $var(apply) configure -state disabled
    $var(cancel) configure -state normal

    if {$var(name)!={}} {
	NSVRServer $varname
    } else {
	ARStatus $varname "Please specify an Object Name"

	$var(mb).file entryconfig Retrieve -state normal
	$var(mb).file entryconfig Cancel -state disabled

	$var(apply) configure -state normal
	$var(cancel) configure -state disabled
    }
}

proc NRESDestroyDialog {} {
    global nres

    set varname nres
    ARDestroy $varname
}

proc NRESPan {varname} {
    upvar #0 $varname var

    if {($var(x) != {}) && ($var(y) != {})} {
	PanTo $var(x) $var(y) $var(system) $var(sky)
    }
}

proc NRESCrosshair {varname} {
    upvar #0 $varname var

    global current
    global ds9

    if {($current(frame) != {})} {
	if {[$current(frame) has wcs equatorial $var(system)]} {
	    if {($var(x) != {}) && ($var(y) != {})} {
		set ds9(mode) crosshair
		ChangeMode
		$current(frame) crosshair \
		    $var(system) $var(sky) $var(x) $var(y)
	    }
	}
    }
}

proc NRESDone {varname} {
    upvar #0 $varname var

    ARStatus $varname "Done"
    ARReset $varname
}

proc ProcessNRESCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global nres

    switch -- [string tolower [lindex $var $i]] {
	server {
	    incr i
	    set nres(nameserver) [lindex $var $i]
	}
	format -
	skyformat {
	    incr i
	    set nres(skyformat) [lindex $var $i]
	}
	name {
	    incr i
	    set nres(name) [lindex $var $i]
	    NRESDialog
	    NRESApply nres 1
	}
	default {
	    set nres(name) [lindex $var $i]
	    NRESDialog
	    NRESApply nres 1
	}
    }
}
