#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerBaseRectDialog {frame id width height unit} {
    global marker
    global ds9

    set w ".marker$id"
    set unit2 [string totitle $unit]

    # variables
    set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    set marker($frame,$id,dlabel) $marker(dialog,dist,system)
    set marker($frame,$id,dformat) $marker(dialog,dist,format)

    # base
    MarkerBaseCenterDialog $frame $id $width $height
    set which $marker($frame,$id,which)

    # menus
    MarkerBaseDistMenu $frame $id $unit $unit2 ${which}DistCB dcoord dformat

    # init
    ${which}DistCB $frame $id
    MarkerBaseCenterRotateCB $frame $id

    # callbacks
    $frame marker $id callback edit ${which}EditCB $frame
    $frame marker $id callback rotate MarkerBaseCenterRotateCB $frame

    # Radius
    label $w.ref.f.radiusTitle -text $unit2
    entry $w.ref.f.radius1 -textvariable marker($frame,$id,radius1) -width 13 
    entry $w.ref.f.radius2 -textvariable marker($frame,$id,radius2) -width 13 
    label $w.ref.f.radiusCoord -textvariable marker($frame,$id,dlabel) \
	-relief groove -width 9 -padx 4

    grid $w.ref.f.radiusTitle $w.ref.f.radius1 $w.ref.f.radius2 \
	$w.ref.f.radiusCoord -padx 4 -sticky w

    label $w.ref.f.angleTitle -text "Angle"
    entry $w.ref.f.angle -textvariable marker($frame,$id,angle) -width 13 
    label $w.ref.f.angleUnit -relief groove -width 9 -padx 4 \
	-text "degrees"

    grid $w.ref.f.angleTitle $w.ref.f.angle x $w.ref.f.angleUnit \
	-padx 4 -sticky w
}

# actions

proc MarkerBaseRectClose {frame id} {
    global marker
    set which $marker($frame,$id,which)

    $frame marker $id delete callback edit ${which}EditCB
    $frame marker $id delete callback rotate MarkerBaseCenterRotateCB
    MarkerBaseCenterClose $frame $id
}

proc MarkerBaseRectApply {frame id} {
    global marker
    set which $marker($frame,$id,which)

    if {$marker($frame,$id,radius1) != {} &&
	$marker($frame,$id,radius2) !={}} {
	$frame marker $id $which radius \
	    $marker($frame,$id,radius1) $marker($frame,$id,radius2) \
	    $marker($frame,$id,dcoord) $marker($frame,$id,dformat)
    }

    MarkerBaseCenterRotate $frame $id
    MarkerBaseCenterApply $frame $id
}

# callbacks

proc MarkerBaseRectCoordCB {frame id} {
    MarkerBaseCoordCB $frame $id
    MarkerBaseCenterMoveCB $frame $id
    MarkerBaseCenterRotateCB $frame $id
}

proc MarkerBaseRectEditCB {frame id} {
    global marker
    set which $marker($frame,$id,which)

    set r [$frame get marker $id $which radius \
	       $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]

    set marker($frame,$id,radius1) [lindex $r 0]
    set marker($frame,$id,radius2) [lindex $r 1]
}

proc MarkerBaseRectDistCB {frame id} {
    global marker
    set which $marker($frame,$id,which)

    MarkerBaseDistCB $frame $id
    ${which}EditCB $frame $id
}

proc MarkerBaseRectDefaultDialog {which unit} {
    global marker
    global ed

    set w ".${which}"

    set ed(ok) 0
    set ed(radius1) $marker($which,radius1)
    set ed(radius2) $marker($which,radius2)

    DialogCreate $w "Default $which" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.title -text "$unit 1"
    entry $w.ed.radius1 -textvariable ed(radius1) -width 10 
    label $w.ed.unit -text "image" -relief groove -width 8
    
    label $w.ed.title2 -text "$unit 2"
    entry $w.ed.radius2 -textvariable ed(radius2) -width 10 
    label $w.ed.unit2 -text "image" -relief groove -width 8

    grid $w.ed.title $w.ed.radius1 $w.ed.unit -padx 4 -pady 1 -sticky w
    grid $w.ed.title2 $w.ed.radius2 $w.ed.unit2 -padx 4 -pady 1 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.radius1 select range 0 end
    DialogWait $w ed(ok) $w.ed.radius1
    DialogDismiss $w

    if {$ed(ok)} {
	set marker($which,radius1) $ed(radius1)
	set marker($which,radius2) $ed(radius2)
    }

    unset ed
}
