// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __box_h__
#define __box_h__

#include "basebox.h"

class Box : public BaseBox {
private:
  void updateHandles();

public:
  Box(const Box&);
  Box(FrameBase* p, const Vector& ctr, const Vector& s, double a,
      const char* clr, int w, const char* f,
      const char* t, unsigned short prop, const char* c, const List<Tag>& tag);

  Marker* dup() {return new Box(*this);}
  void editBegin(int);
  void edit(const Vector&, int);
  void editEnd();

  Vector getSize() {return size[0].abs();}
  void setSize(const Vector&);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOimage(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif
