// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fitshist_h__
#define __fitshist_h__

#include "vector.h"
#include "file.h"

class FitsHist : public FitsFile {
 public:
  enum Function {SUM, AVERAGE};
  enum Smooth {BOXCAR, TOPHAT, GAUSSIAN};

 private:
  int width;
  int height;
  int depth;
  off_t size;

  FitsColumn* xcol;
  FitsColumn* ycol;
  FitsColumn* zcol;

  void* fitsy;
  void* filter;

  int initHeader(FitsFile*, Matrix&);
  void initLTMV(Matrix&);
  void initWCS(FitsFile*, Matrix&, Vector);
  void initWCSAlt(FitsFile*, Matrix&, Vector);
  void initFilter(FitsFile*);
  void deleteFilter();
  void bin(FitsFile*, Matrix&, Function, Vector);
  void boxcar(int);
  void tophat(int);
  void gaussian(int);
  void convolve(float*, int);
  void swap();

 public:
  FitsHist(FitsFile* src, int width, int height, int depth, 
	   Matrix& m, Function func, Vector block, 
	   int sm, Smooth smf, int size);
  ~FitsHist();
};

class FitsHistNext : public FitsFile {
public:
  FitsHistNext(FitsFile* prev);
};

#endif
