/*
 *	Copyright (c) 1999-2003 Smithsonian Astrophysical Observatory
 */

/*
 *
 * NaN.h -- include file to deal with IEEE NaN values
 *
 * Idea taken from fitsio2.h in the cfitsio package by William Pence (HEASARC),
 * to whom grateful acknowledgement is made.
 *
 * These functions tests whether the float value is a reserved IEEE
 * value such as a Not-a-Number (NaN), or underflow, overflow, or
 * infinity.   The functions returns 1 if the value is a NaN, overflow
 * or infinity; otherwise it returns 0.
 *
 * isnanf tests floats, isnand tests doubles.
 *
 */
#ifndef	__nan_h
#define	__nan_h

#define NATIVE             0 /* generic machine using IEEE formats */
#define ALPHA              1
#define IBMPC              2

/* the following are used to determine what type machine we are running on */
#if defined(__alpha)
 
#define NAN_MACHINE ALPHA
#define BYTESWAPPED 1
 
#elif defined(__linux__) && ( defined(__i386__) || defined(__i486__) || defined(__i586__) )

/*  IBM PC running linux */
#define NAN_MACHINE IBMPC
#define BYTESWAPPED 1

#elif defined(_MSC_VER) || defined(__BORLANDC__) || defined(__TURBOC__) || defined(_WIN32)

/*  IBM PC running DOS or Windows */
#define NAN_MACHINE IBMPC       
#define BYTESWAPPED 1

#elif defined(_NI_mswin_)

/*  LabWindows/CVI with Windows 3.x, 95, or NT  */
#define NAN_MACHINE IBMPC       
#define BYTESWAPPED 1

#elif  defined(__EMX__)

/*  IBM PC running OS/2 */
#define NAN_MACHINE IBMPC
#define BYTESWAPPED 1

#else

/*  assume machine uses the same IEEE formats as used in FITS files */
#define NAN_MACHINE NATIVE
#define BYTESWAPPED 0
 
#endif
 
/* byte-swapping determine which short int we will mask for NaN test */
#if (BYTESWAPPED == 1)

#define FNANOFF 1
#define DNANOFF 3

#else

#define FNANOFF 0
#define DNANOFF 0

#endif

#define FNANMASK   0x7F80 /* mask bits 1 - 8; all set on NaNs */
                                     /* all 0 on underflow  or 0. */
 
#define DNANMASK   0x7FF0 /* mask bits 1 - 11; all set on NaNs */
                                     /* all 0 on underflow  or 0. */
 
#ifndef isnanf
#define isnanf(X) ((((union { float f; short x[2]; } \
                        *)&X)->x[FNANOFF] & FNANMASK) == FNANMASK)
#endif

#ifndef isnand
#define isnand(X) ((((union { double d; short x[4]; } \
                        *)&X)->x[DNANOFF] & DNANMASK) == DNANMASK)
#endif
 
#include <prsetup.h>

_PRbeg

float  getnanf _PRx((void));
double getnand _PRx((void));

_PRend

#endif
