// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorbarpseudo8_h__
#define __colorbarpseudo8_h__

#include "colorbar.h"

// Colomap(s) will contain a variable number of color cells, based on 
// available color cells and if a private Colormap is used.

class ColorbarPseudoColor8 : public Colorbar {
private:
  int privateUsed;           // flag to indicate private allocated
  Colormap colormap;         // current Colormap

private:
  int initColormap();           // initialize current colormap
  void updateColors();          // ColorMapInfo to Colormap
  int updatePixmap(const BBox&); // renders image/graphics into pixmap

  int initDefaultMap();      // initialize default colormap
  int initPrivateMap();      // initialize private colormap

public:
  ColorbarPseudoColor8(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  ~ColorbarPseudoColor8();

  void setColormapWindowCmd(char*);
};

#endif
