#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ButtonCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair begin motion canvas $x $y

    if {$crosshair(lock) != "none"} {
	set coord [$which get crosshair $crosshair(lock) scientific]
	foreach f $ds9(frames) {
	    if {$f != $which && [$f has system $crosshair(lock)]} {
		switch -- $ds9(display,mode) {
		    single {$f crosshair $crosshair(lock) $coord}
		    tile {$f crosshair begin motion $crosshair(lock) $coord}
		    blink {}
		}
	    }
	}
    }
}

proc MotionCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair motion canvas $x $y

    if {$crosshair(lock) != "none"} {
	set coord [$which get crosshair $crosshair(lock) scientific]
	foreach f $ds9(frames) {
	    if {$f != $which && [$f has system $crosshair(lock)]} {
		switch -- $ds9(display,mode) {
		    single {$f crosshair $crosshair(lock) $coord}
		    tile {$f crosshair motion $crosshair(lock) $coord}
		    blink {}
		}
	    }
	}
    }
}

proc ReleaseCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair canvas $x $y

    if {$crosshair(lock) != "none"} {
	set coord [$which get crosshair $crosshair(lock) scientific]
	foreach f $ds9(frames) {
	    if {$f != $which && [$f has system $crosshair(lock)]} {
		$f crosshair $crosshair(lock) $coord
	    }
	}
    }
}

proc ArrowKeyCrosshair {which x y} {
    global ds9
    global crosshair

    $which crosshair warp $x $y

    if {$crosshair(lock) != "none"} {
	set coord [$which get crosshair $crosshair(lock) scientific]
	foreach f $ds9(frames) {
	    if {$f != $which && [$f has system $crosshair(lock)]} {
		$f crosshair $crosshair(lock) $coord 
	    }
	}
    }
}
