#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - This tests handling of RFC822 comments within Boundary strings,
    where the sanitizer doesn't actually chose between possible 
    boundary strings until message processing has begun.

  - Test the Transfer-Encoding fixer-upper code.

tac
$ANOMY/bin/sanitizer.pl $SAN_CONF \
      'feat_testing = 1' \
      'feat_log_inline = 1' \
      'file_list_2_policy = accept' \
      'file_list_2 = (?i)\.txt$' \
      'file_list_7 = 0' \
      "header_rev = 0" <<EOF 2>test.log >test.out
From bre Fri Jan 30 03:37:34 1998
Date: Wed, 13 Dec 2000 17:13:26 +0800
From: Admin <foo@bar.com>
Subject: Yet another MIME test
To: Admin <baz@bar.com>
MIME-Version: 1.0
Content-Type: MULTIPART/ALTERNATIVE; boundary=Boundary_(THIS_DOESNT_GET_DROPPED)
Content-Transfer-Encoding: quoted-printable

--Boundary_(THIS_DOESNT_GET_DROPPED)
Content-type: text/plain; format=flowed; charset=us-ascii
Content-disposition: attachment; name="evil.exe"

Part one
--Boundary_(THIS_DOESNT_GET_DROPPED)
Content-type: text/plain; charset=us-ascii

Part two
--Boundary_(THIS_DOESNT_GET_DROPPED)--

EOF
echo "*** Exit code was $? ***" >>test.out

$ANOMY/bin/sanitizer.pl $SAN_CONF \
  'feat_log_inline = 1' \
  'file_list_2_policy = accept' \
  'file_list_2 = (?i)\.txt$' \
  'file_list_7 = 0' \
  'feat_testing = 1' "header_rev = 0" <<EOF 2>>test.log >>test.out
From bre Fri Jan 30 03:37:34 1998
Date: Wed, 13 Dec 2000 17:13:26 +0800
From: Admin <foo@bar.com>
Subject: Yet another MIME test
To: Admin <baz@bar.com>
MIME-Version: 1.0
Content-Type: MULTIPART/ALTERNATIVE; boundary=Boundary(THIS_GETS_DROPPED)
Content-Transfer-Encoding: 8bit

--Boundary
Content-type: text/plain; format=flowed; charset=us-ascii
Content-disposition: attachment; name="evil.exe"

Part one
--Boundary
Content-type: text/plain; charset=us-ascii

Part two
--Boundary--

EOF
echo "*** Exit code was $? ***" >>test.out

$ANOMY/bin/sanitizer.pl $SAN_CONF \
  'feat_log_inline = 1' \
  'file_list_2_policy = accept' \
  'file_list_2 = (?i)\.txt$' \
  'file_list_7 = 0' \
  'feat_testing = 1' "header_rev = 0" <<EOF 2>>test.log >>test.out
From bre Fri Jan 30 03:37:34 1998
Date: Wed, 13 Dec 2000 17:13:26 +0800
From: Admin <foo@bar.com>
Subject: Yet another MIME test
To: Admin <baz@bar.com>
MIME-Version: 1.0
Content-Type: MULTIPART/ALTERNATIVE;
Content-Transfer-Encoding: 8bit

--Boundary
Content-type: text/plain; format=flowed; charset=us-ascii
Content-disposition: attachment; name="evil.exe"

Part one
--Boundary
Content-type: text/plain; charset=us-ascii

Part two
--Boundary--

EOF
echo "*** Exit code was $? ***" >>test.out
