
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                    Module Library:                    //
//                       io_shapes                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                         stl.h                         //
//                                                       //
//                 Copyright (C) 2008 by                 //
//                      Olaf Conrad                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation; version 2 of the License.   //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not,       //
// write to the Free Software Foundation, Inc.,          //
// 59 Temple Place - Suite 330, Boston, MA 02111-1307,   //
// USA.                                                  //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Goettingen               //
//                Goldschmidtstr. 5                      //
//                37077 Goettingen                       //
//                Germany                                //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------


///////////////////////////////////////////////////////////
//														 //
//														 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#ifndef HEADER_INCLUDED__stl_H
#define HEADER_INCLUDED__stl_H

//---------------------------------------------------------
#include "MLB_Interface.h"


///////////////////////////////////////////////////////////
//														 //
//														 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CSTL_Import : public CSG_Module
{
public:
	CSTL_Import(void);

	virtual const SG_Char *	Get_MenuPath		(void)	{	return( _TL("R:Import") );	}


protected:

	virtual bool			On_Execute			(void);


private:

	typedef struct
	{
		float				x, y, z;
	}
	TSTL_Point;

	typedef struct
	{
		int					x, y;

		double				z;
	}
	TGRD_Point;


	double					r_sin_x, r_cos_x, r_sin_y, r_cos_y, r_sin_z, r_cos_z;

	CSG_Grid				*m_pGrid;


	bool					Read_Facette		(CSG_File &Stream, TSTL_Point p[3]);
	void					Rotate				(TSTL_Point &p);

	void					Set_Triangle		(TGRD_Point p[3]);
	void					Set_Triangle_Line	(int xa, int xb, int y, double za, double zb);
	void					Set_Triangle_Point	(int x, int y, double z);

};


///////////////////////////////////////////////////////////
//														 //
//														 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CSTL_Export : public CSG_Module
{
public:
	CSTL_Export(void);

	virtual const SG_Char *	Get_MenuPath		(void)	{	return( _TL("R:Export") );	}


protected:

	virtual bool			On_Execute			(void);


private:

	bool					Get_Normal			(CSG_TIN_Triangle *pTriangle, int zField, float Normal[3]);

};


///////////////////////////////////////////////////////////
//														 //
//														 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#endif // #ifndef HEADER_INCLUDED__stl_H
