/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file GtkGUI.h
    \author Romain BONDUE
    \date 21/07/2005 */
#ifndef __GTKGUI_H__
#define __GTKGUI_H__

#include <string>
#include <stdexcept>
#include <memory> // auto_ptr<>

extern "C"{
#include <gtk/gtk.h>
}
#if !GTK_CHECK_VERSION (2, 6, 0)
#error Invalid GTK+ headers, require at least version 2.6.
#endif

#include "Exceptions.h"
#include "CLinkStatusTab.h"
#include "CSiteSurveyTab.h"
#include "CStatsPage.h"
#include "CProfileTab.h"
#include "TrayIcon.h"
#include "PrefsPage.h"
#include "CLIOpt.h"



namespace nsWireless
{
    class CEncryptionD;
    class CDeviceInfo;
    class CQuality;
    class CMacAddress;

} // namespace nsWireless



namespace nsCore{class IModule;}



namespace nsNet{class CInterface;}



namespace nsGUI
{
    class CStatsPage;


    void NotifyError (const std::string&, int, ::GtkWindow*) throw();


    bool AskUser (const std::string&, ::GtkWindow*) throw();


    class CGtkGUI
    {
      public :
        CGtkGUI () throw (nsErrors::CException);
        ~CGtkGUI () throw (nsErrors::CException);

        void Run (const nsCore::CCLIOpt&) throw (nsErrors::CException);

        bool Connect (unsigned) throw();
        void Scan () throw();
        void StopScanning () throw();

        bool ApplyProfile (unsigned) throw();
        bool DeleteProfile (unsigned) throw();
        const nsUserData::CProfile* EditProfile () throw();
        const nsUserData::CProfile* NewProfile () throw();
        bool NewProfile (unsigned) throw();
        void RefreshRates () throw();
        bool BecomeRoot () throw (nsErrors::CException);
        bool IsRoot () const throw();

            /** \return "true" means that the calling function should clean
             *          everything and return. */
        bool ProcessError (const nsErrors::CException&) throw();

        operator const ::GtkWindow* () const throw();
        operator ::GtkWindow* () throw();


      private :
        CGtkGUI& operator= (const CGtkGUI&);
        CGtkGUI (const CGtkGUI&);

        void SetNoRoot () throw();
        void SetRoot () throw();
        void SetWindowIcons () throw();
        unsigned CreateProfile (unsigned CellNum) throw();
        void SelectMatchingProfile (const nsWireless::CCell&) throw();
        void SelectMatchingProfile (unsigned ProfileI) throw();
        bool ChangeModule (const std::string& = std::string())
                                                throw (nsErrors::CException);
        void SelectCurrentCell () throw (nsErrors::CSystemExc);
        void SelectCurrentCell (const nsWireless::CMacAddress&) throw();
        void SetIPFromProfile (unsigned ProfileI) throw (nsErrors::CException);
        void RefreshLinkStatus () throw (nsErrors::CException);
        /** \param unsigned The TX rate in Mbps. */
        void RefreshLinkStatus (const nsWireless::CQuality&, unsigned,
                                const nsWireless::CMacAddress&)
                                                throw (nsErrors::CException);
        bool RefreshStats () throw();
        /** \param unsigned The TX rate in Mbps. */
        void RefreshTray (const nsWireless::CQuality&, unsigned) throw();
        void LoadOptions () throw();
        void StoreData () throw (nsErrors::CException);
        bool IsIgnored () const throw();
        void IsIgnored (bool) throw();
        bool IsStatsAvailable () const throw();
        void IsStatsAvailable (bool) throw();
        bool BringIfaceUp () throw();
        void IfaceIsDown () throw();
        void TrayIconMenu (::GdkEventButton&) throw();
        ::GtkWidget* MakeMenuVisibilityItem () throw();
        ::GtkWidget* MakeMenuProfileItem() throw();
        ::GtkWidget* MakeMenuExitItem() throw();

        enum PageNum_e {LinkStatus, Stats, Profiles, SiteSurvey, Preferences,
                        Private};

        enum {IsRootF = 1, IsIgnoredF = 2, IsStatsAvailableF = 4};

        std::auto_ptr<nsCore::IModule> m_pModule;
        ::GtkWindow* const m_pWindow;
        ::GtkNotebook* const m_pNoteBook;
            // I use this because C++ exception can't go through gtk.
        nsErrors::CException m_Exc;
        CLinkStatusTab m_LinkStatusTab;
        unsigned m_GlobalTimer;
        CStatsPage m_StatsPage;
        std::auto_ptr<nsNet::CInterface> m_pIface;
        CSiteSurveyTab m_SiteSurveyTab;
        CellVec_t m_CellVec;
        unsigned m_SiteSurveyTabTimer;
        unsigned m_TimeRemaining;
        CProfileTab m_ProfileTab;
        CTrayIcon m_TrayIcon;
        std::string m_ToolTipHeader;
        unsigned char m_Flags;
        CPrefsPage m_PrefsPage;
        unsigned m_LeaveRootModeTimer;
        unsigned m_CurrentRateIndex;
        ::GtkMenuShell* m_pTrayMenu;
        ::gulong m_ExitHandlerID;


        static int DeleteCallBack (::GtkWidget*, ::GdkEvent*, void*) throw();
        static void PageSwitchCallBack (::GtkNotebook*, ::GtkNotebookPage*,
                                        PageNum_e, CGtkGUI*) throw();
        static bool GlobalTimerWithTrayCallBack (CGtkGUI*) throw();
        static bool GlobalTimerWithoutTrayCallBack (CGtkGUI*) throw();
        static bool RefreshCellListCallBack (CGtkGUI*) throw();
        static void TrayIconClickedCallBack (CGtkGUI*, ::GdkEventButton*)
                                                                    throw();
        static void ChangeInterfaceCallBack (CGtkGUI*) throw();
        static void AutoLeaveRootModeCallBack (CGtkGUI*) throw();
        static bool LeaveRootModeTimerCallBack (CGtkGUI*) throw();
        static void RootModeChangedCallBack (CGtkGUI*) throw();
        static void RateChangedCallBack (CGtkGUI*) throw();
        static bool RefreshRateDelayedCallBack (CGtkGUI*) throw();
        static void DisplayTrayIconButtonCallBack (CGtkGUI*) throw();
        static void IfaceStatusChangedCallBack (CGtkGUI*) throw();
        static void HideCallBack (CGtkGUI*) throw();
        static void ShowCallBack (CGtkGUI*) throw();
        static void CreateProfileAndApplyCallBack (CGtkGUI*) throw();
        static void ApplyProfileTrayCallBack (::gpointer) throw();

    }; // CGtkGUI

} // namespace nsGUI

#include "private/GtkGUI.hxx"

#endif // __GTKGUI_H__
