//rumbaview timeview.h

#ifndef TIMEVIEW_H
#define TIMEVIEW_H

#include <qframe.h>
#include <qpainter.h>
#include <qtimer.h>
#include <qpopupmenu.h>

#include <rumba/manifold.h>

#define MAX_MODE 5

/**
  *@author Giorgio Grasso, Ben Bly, Donovan Rebbechi
  */

enum Mode { RAW=0, SCALED, INTENSITY, FFT_POWER };

/**
 *
 *	TimeView: blah blah blah
 *
 */


class TimeView : public QFrame  {
	Q_OBJECT
public: 
	/**
	 * Constructor.
	 * --------------------- */
	TimeView(QWidget *parent=0);
	~TimeView();
	void setManifold(RUMBA::Manifold<short> *vol);

signals:
	void cursorMoved(int t);

public slots:
	void slotCursorMoved(int x, int y, int z);
	void slotWindowMoved(int dx, int dy);
	void slotRecompose(QRect out, QRect in);

private slots:
	void changeAnimate();
	void updateAnimate();
	void setRAW();
	void setSCALED();
	void setINTENSITY();
	void setFFT_POWER();

protected:
	virtual void mousePressEvent(QMouseEvent *qme);
	virtual void mouseMoveEvent(QMouseEvent *qme);
	virtual void resizeEvent(QResizeEvent *qre);
	virtual void paintEvent(QPaintEvent *qpe);
	virtual void keyPressEvent(QKeyEvent *qke);

private:
	void showGraph();
	void updateGraph();
	void clearModes();

	RUMBA::Manifold<short> *volume;
	QPopupMenu *menu;
	int id_animate;
	int n_mode, id_mode[MAX_MODE];
	QPainter *painter;
	QTimer *animate_timer;
	int cx, cy, cz, ct;
	Mode mode;
	int *points;
	float avg;
	bool cursor, animate;
	int text_height;
};

#endif
