#include "header_view.h"

#include <string>
#include <map>
#include <rumba/splodge.h>

using std::string;
using std::map;
using RUMBA::Splodge;
using RUMBA::BaseManifold;

HeaderView::HeaderView(QWidget* parent, const char *name, WFlags f)
	:QListBox(parent,name,f)
{

};


HeaderView::HeaderView(
	const BaseManifold& M,
	QWidget* parent , const char *name , WFlags f
)
	:QListBox(parent,name,f)
{
	setManifold(M);
	show();

};

void HeaderView::setManifold(const BaseManifold& M)
{
	string s;
	clear();
	map<string, Splodge>::const_iterator it =  
		const_cast<BaseManifold&>(M).headerData().begin();
	for ( ; it != const_cast<BaseManifold&>(M).headerData().end(); ++it )
	{
		s = it->first;
		s += ": ";
		s += it->second.asString();
		insertItem(s.c_str());
	}

}
