#include <cmath>
#include <algorithm>
#include <rumba/fft.h>

using namespace std;
using namespace RUMBA;

int RUMBA::bit_reverse_impl(int x, int nbits)
{
	int y = 0;
	for (int i =0; i<nbits; ++i)
	{ 
		y<<=1; 
		if (x%2) 
			++y; 
		x>>=1; 
	}
	return y;
}

BitReverseFunctor RUMBA::bit_reverse;

int BitReverseFunctor::operator()(int x, int nbits)
{
	map<int, vector<int> >::iterator it = table.find(nbits);
	if (it == table.end())
	{
		compute_row(nbits);
		it = table.find(nbits);
	}
	return it->second[x];
}

void BitReverseFunctor::compute_row(int nbits)
{
	int max = 1 << (nbits+1);
	vector<int> v;
	table.insert(make_pair(nbits,v));
	table[nbits].resize(max);

	for (int i=0;i<max;++i)
		table[nbits][i] = bit_reverse_impl(i,nbits);
}


void RUMBA::bit_reverse_transform(vector<complex<double> >& v)
{
	int s = v.size();
	int new_size = 1;
	int nbits = 0;

	while (s>new_size) 
	{
		new_size<<=1;
		++nbits;
	}
	if ( s != new_size ) 
		v.resize(new_size);

	for (int i = 0; i<new_size; ++i)
		if (i <bit_reverse(i,nbits))
			std::swap(v[i],v[bit_reverse(i,nbits)]);
}

int RUMBA::base_2_log(int n)
{
	if (n<=0)
		throw 0;
	int res=0;
	--n;
	do 
	{
		++res;
	} while (n>>=1);
	return res;
}

void RUMBA::fft (vector<complex<double> >& v)
{
	int n,lgn;	
	int m;
	complex<double> u,t;
	static const double pi = 4*atan(1);
	complex<double> omega_m;
	complex<double> omega;

	bit_reverse_transform(v);
	n = v.size();
	lgn = base_2_log(n);


	for ( int s = 1; s <= lgn; ++s )
	{
		m = 1<<s;
		omega_m = exp ( 2 *  pi * complex<double>(0,1) / m);
		omega = 1;
		for (int j=0;j<=m/2-1;++j)
		{
			for ( int k=j; k<n; k+=m )
			{
				t = omega * v[k+m/2];
				u = v[k];
				v[k] = u+t;
				v[k+m/2] = u-t;
			}
			omega *= omega_m;
		}
	}
}

#ifdef TEST_RUMBA_FFT
#include <iostream>

int main()
{

	vector<complex<double> > v;
	double x,y;

	char resp='y';
	do 
	{
		if (cin >> x >> y)
			v.push_back (complex<double>(x,y));
		else
			break;

		cout << "enter data, y/n ?\n";
		cin >> resp;
		
	}while (resp != 'n');

	fft(v);

	copy (v.begin(),v.end(),ostream_iterator<complex<double> > (cout, " " ));
	cout << endl;
}



#endif
