#include <iostream>

#include <rumba/svd.h>
#include <rumba/matrixio.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/arghandler.h>


using RUMBA::Argument;
using RUMBA::ManifoldMatrix;
using RUMBA::Manifold;

Argument myArgs[] = {
	Argument( "bigmatrix", RUMBA::ALPHA, 'b', "" ),
	Argument( "singular", RUMBA::ALPHA, 's', "" ),
	Argument()
};

void usage()
{
	std::cerr << "Usage: svd (--infile|-i) infile (-o|--outfile) outfile "
		"[ (--singular|-s) singular ] [ (--bigmatrix|-b) bigmatrix \n"
		"infile: the input file containing the matrix M to be decomposed \n"
		"  M = UDV^t\n"
		"outfile: the output file for V (required)\n"
		"singular: the output file for D\n"
		"bigmatrix: the output file for U\n" << std::endl;

}
	

int main(int argc, char** argv)
{
	RUMBA::ArgHandler argh(argc,argv,myArgs);
	std::string infile, outfile, bigmatrix, singular;
	
	try 
	{
		if (argh.arg("help"))
		{
			usage();
			return 0;
		}
		argh.arg( "infile", infile );
		argh.arg( "outfile", outfile );
		argh.arg( "bigmatrix", bigmatrix );
		argh.arg( "singular", singular );
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl; exit(1);
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl; exit(1);
	}
	catch (RUMBA::MissingArgumentException& s)
	{
		std::cerr << "Missing argument: " << s.error() << std::endl; exit(1);
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl; exit(1);
	}
	catch (RUMBA::Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl; exit(1);
	}


	ManifoldMatrix M = RUMBA::manifoldMatrixReadHack ( infile.c_str());
	ManifoldMatrix U (makeMatrix(Manifold<double>()));
	ManifoldMatrix V (makeMatrix(Manifold<double>()));
	ManifoldMatrix D (makeMatrix(Manifold<double>()));

	try
	{
		if ( bigmatrix.empty() )
		{
			destructive_svd ( M, V, D );
			RUMBA::manifoldMatrixWriteHack ( V, outfile.c_str() );
			if (! singular.empty() )
				RUMBA::manifoldMatrixWriteHack( D, singular.c_str());
		}
		else
		{
			RUMBA::destructive_svd (M, M, V, D );
			RUMBA::manifoldMatrixWriteHack( U, bigmatrix.c_str() );
			RUMBA::manifoldMatrixWriteHack( V, outfile.c_str() );
			if (! singular.empty() )
				RUMBA::manifoldMatrixWriteHack( D, singular.c_str());
		}
			
	}
	catch (RUMBA::Exception& e)
	{
		std::cerr << e.error() << std::endl;
	}

}
