
#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrix.hpp>
#include <rumba/matrixio.h>

#include "mmiohack.h"

using namespace RUMBA;

ManifoldMatrix manifoldMatrixReadHack(std::string filename)
{
	if (filename.empty()) {
		return ( makeMatrix ( loadAsciiManifold ( std::cin ) ) );
	}
    else if (fileExtension(filename) == ".txt") {
		return makeMatrix(loadAsciiManifold ( filename.c_str() ) );
    }
    else {
	 	return ( makeMatrix( Manifold<double> ( filename.c_str() ) ) );
    }
}

void manifoldMatrixWriteHack(const ManifoldMatrix& mM , std::string filename )
{
	if (filename.empty()) {
		writeManifoldMatrix( mM, std::cout );
	}
	else if (fileExtension(filename) == ".txt") {
		writeManifoldMatrix( mM , filename.c_str() );
	}
	else {
		mM.headerData["hist_description"] = 
			(mM.Transpose ? "transposed matrix" : "matrix");
		mM.M.save(filename.c_str());
	}
}

