#include <iostream>
#include <strstream>
#include <vector>
#include <fstream>
#include  "newmat/newmat.h"
#include "newmat/newmatap.h"

void readMatrix ( Matrix& M, istream& fin ) 
{
	int i,j,k;
	int cols = 0;
	int rows = 0;
	char a[256];
	double d;
	vector<double> v;

	// Count columns
	fin.getline(a,256);
	istrstream* s = new istrstream (a);
	while ( (*s) >> d )
	{
		v.push_back ( d );
		cols++;
	}
	delete s;

	for ( rows = 1; fin.getline(a,256); ++rows )
	{
		s = new istrstream(a);
		for ( i = 0; i < cols; ++i )
		{
			(*s) >> d;	
			v.push_back ( d );
		}
		delete s;
	}

	M.ReSize ( rows, cols );

	for ( i = 0, k =0; i < rows; ++i ) {
		for ( j = 0; j < cols; ++j ) {
			M.element(i,j) = v[k];
			++k;
		}
	}

	#ifdef DEBUG
	cerr << cols << endl;
	cerr << rows << endl;
	vector<double>::const_iterator it;
	for ( it = v.begin(); it != v.end(); ++it )
		cerr << *it << endl;

	for ( i = 0, k =0; i < rows; ++i ) {
		for ( j = 0; j < cols; ++j ) {
			cerr << M.element(i,j) << " ";
		}
		cerr << endl;
	}


	#endif

}

void printMatrix (Matrix& X)
{
	for ( int i = 0; i < X.Ncols(); ++i )
	{
		for ( int j = 0; j < X.Nrows(); ++j )
		{
			cout << X.element(j,i) << " ";
		}
		cout << endl;
	}
}

void printDMatrix (DiagonalMatrix& X)
{
	for ( int i = 0; i < X.Ncols(); ++i )
	{
		for ( int j = 0; j < X.Ncols(); ++j )
		{
			if ( i==j )
				cout << X.element(i);
			else 
				cout << 0;
			cout << " ";
		}
		cout << endl;
	}
}



int main(int argc, char** argv)
{
	std::istream* stream = 0;
	std::ifstream fin;
	if ( argc < 2 )
		stream = &std::cin;
	else
	{
		fin.open(argv[1]);
		if (!fin) 
		{
			std::cerr << "Couldn't open " << argv[1] << std::endl;
			abort();
		}
		stream = &fin;
	}
		
	Matrix M;
	readMatrix(M,*stream);
	DiagonalMatrix D(M.Ncols());
	Matrix U(M.Nrows(),M.Ncols());
	Matrix V(M.Ncols(),M.Ncols());

	SVD(M,D,U,V);

	cout << "U:----------------\n";
	printMatrix(U);

	cout << "V:----------------\n";
	printMatrix(V);

	cout << "D----------------\n";
	printDMatrix(D);

	cout << "----------------------\n";
	Matrix result(U*D*V.t() - M);
	printMatrix(result);
}
