#include <rumba/arghandler.h>
#include <rumba/manifoldFile.h>
#include <rumba/manifold.h>


using namespace RUMBA;
using std::cerr; using std::endl;

void usage()
{
	cerr << "Usage: mask-transform (--mask|-m) maskfile"
		" (--infile|-infile) infile (--outfile|-o) outfile" << endl;
}


Argument myArgs [] = {
	Argument( "mask", RUMBA::ALPHA , 'm', RUMBA::Splodge(), true ),
	Argument()

};


int main(int argc,char** argv)
{
	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setRequiredDefaultArg("outfile");
	std::string infile,outfile,maskfile;
	RUMBA::ManifoldFile* fin = 0; 
	RUMBA::Manifold<char> mask;
	RUMBA::ManifoldFile* fout = 0;
	bool pixel_mask;

	try {
		RUMBA::ArgHandler argh ( argc , argv, myArgs );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}

		argh.arg("infile",infile);
		argh.arg("outfile",outfile);
		argh.arg("mask",maskfile);


		try {
			mask.load (maskfile.c_str());
		}
		catch ( ... )
		{
			cerr << "Couldn't open file " << maskfile.c_str() << endl;
			exit(1);
		}
		fin = RUMBA::ManifoldFile::construct(infile.c_str());
		fout = RUMBA::ManifoldFile::construct(
			outfile.c_str(),
			fin->headerData()["normalized_datatype"].asString(),
			fin->extent()
		);

		fin->setCacheStrategy(RUMBA::CACHE_VOL);
		fout->setCacheStrategy(RUMBA::CACHE_VOL);

	
		if (!fin){ cerr<<"Couldn't open "<<infile.c_str()<<endl;exit(1);}
		if (!fout){ cerr<<"Couldn't open "<<outfile.c_str()<<endl;exit(1);}
	
		if ( mask.timepoints() >1 )
		{
			pixel_mask = false;
		}
		else if ( mask.pixels() == fin->pixels() )
		{
			pixel_mask = true;
		}
		else 
		{
			throw RUMBA::Exception("Mask size incorrect");
		}
	
		if (pixel_mask)
		{
			for ( int i = 0; i < fin->size(); ++i )
				(*fout)[i] = (mask[i%fin->pixels()] ?
					static_cast<double>((*fin)[i]) : 0 
				);
		}
		else
		{
			for ( int i = 0; i < fin->size(); ++i )
				(*fout)[i] = (mask[i/fin->pixels()] ?
					static_cast<double>((*fin)[i]) : 0
				);
		}

		delete fin;
		delete fout;
			
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}


	return 0;
}
