#include <string>
#include <vector>
#include <iostream>

void skip_whitespace(const std::string & s, unsigned int& i )
{
	while ( i < s.length() && s[i] == ' ' )
		++i;
}

void tokenize ( const std::string& s, std::vector<std::string>& tokens )
{
	tokens.clear();
	char c_last = '\0'; // last non-whitespace character seen
	std::string tok;

	unsigned int i = 0;
	while ( i < s.length() )
	{

		if ( s[i] == ' ' )	
		{
			if ( i >= 1 )
				c_last = s[i-1];

			switch (c_last)
			{

				case ',':
				case ':':
					tok += s[i];
					skip_whitespace(s,i);
					break;
				default:
					c_last = s[i-1];
					skip_whitespace(s,i);
					tokens.push_back(tok);
					tok = "";
			}
		}
		else
		{
			tok += s[i];
			++i;
		}
	}
	tokens.push_back(tok);
}

std::string toUpper ( const std::string& s)
{
	std::string res; res.resize ( s.length() );
	for ( unsigned int i = 0; i < s.length(); ++i )
		res[i] =  (char)toupper(s[i]);
	return res;
}


#ifdef TOKENIZER_PROG
int main(int argc,char** argv)
{
	if (argc <= 1)
		exit(0);
	std::string s(argv[1]);

	std::vector<std::string> tokens;
	tokenize (s,tokens);
	std::copy ( tokens.begin(), tokens.end(), 
			std::ostream_iterator<std::string>(std::cout, "*\n" ) );

}
#endif
