#include <rumba/rumba_system.h>
#include <rumba/dl.h>
#include <rumba/parse.h>

#include <algorithm>
#include <string>

#include <dlfcn.h>

using RUMBA::fileExtension;

void testFileExtension()
{
	std::string s = "foo.tar.gz";
	if ( fileExtension (s) == ".gz" )
		cout << "OK";
	else
		cout << "Not OK, got " << fileExtension(s) << endl;

	s = "foo.gz";
	if ( fileExtension (s) == ".gz" )
		cout << "OK";
	else
		cout << "Not OK, got " << fileExtension(s) << endl;

	s = "..";
	if ( fileExtension (s) == "." )
		cout << "OK";
	else
		cout << "Not OK, got " << fileExtension(s) << endl;

	s = "bar";
	if ( fileExtension (s) == "" )
		cout << "OK";
	else
		cout << "Not OK, got " << fileExtension(s) << endl;


}



using std::cout;
using std::endl;
int main()
{
	testFileExtension();
	list<void*> v = RUMBA::dl_init();
	
	cout << "Length: " << v.size() << endl;
	cout << RUMBA::get_dlname("/home/elflord/rumba/lib/filetypes/libAnalyzeFile.la");

	RUMBA::dl_shutdown(v);

}
