#ifndef RUMBA_MATRIXIO_H
#define RUMBA_MATRIXIO_H

/**
 * \file matrixio.h
 * \author Donovan Rebbechi, Ben Bly, Giorgio Grasso
 * Copyright Ben Bly. This file is released under the artistic license.
 * See the file COPYING for details.
 */


#include <rumba/manifold.h>
#include <rumba/manifoldmatrix.h>

#include <string>
#include <vector>
#include <iostream>

namespace RUMBA
{




RUMBA::ManifoldMatrix RUMBA::manifoldMatrixReadHack(std::string filename);
void RUMBA::manifoldMatrixWriteHack(const RUMBA::ManifoldMatrix&, std::string filename);

RUMBA::ManifoldMatrix readManifoldMatrix(std::istream& in );
RUMBA::Manifold<double> loadAsciiManifold(std::istream& in );

RUMBA::ManifoldMatrix readManifoldMatrix(const char* filename);
RUMBA::Manifold<double> loadAsciiManifold(const char* filename);

void writeManifoldMatrix (const ManifoldMatrix& M, std::ostream& = std::cout);
void writeManifoldMatrix (const ManifoldMatrix& M, const char* filename );


bool hasDouble(std::string);
int countcolumns(std::string s);
int getRow ( std::string line, std::vector<double>& v );

}
#endif
