#ifndef RUMBA_HOUSEHOLDER_H
#define RUMBA_HOUSEHOLDER_H


/**
  * \file householder.h
  * \author Donovan Rebbechi, Ben Bly, Giorgio Grasso
  * Copyright Ben Bly
  * This file is released under the artistic license. See the file
  * COPYING for details.
  */



#include <rumba/manifoldmatrix.h>

namespace RUMBA
{



/** retrieve a Householder vector for the vector x. The Householder vector v(x)
* satisfies the property that r_v(x) = (1,0, ... 0) where r_v(x) is the 
* reflection in the plane orthogonal to v(x)
*/
ManifoldMatrix houseHolderVector (ManifoldMatrix x, double & beta );

/** overwrites A with a bidiagonal matrix. Stores the essential part of 
*  the Householder vectors in A.
*/
void houseHolderBiDiagonalize ( ManifoldMatrix&  A);

/** compute hh(v) * M, where v is a column vector
*
* If skip is set to true, then it is assumed that the first M.rows()-v.rows() 
* have been zeroed. This is also handy for implementing bidiagonalization 
* where the Householder vectors are stored in the zeroed columns. You probably 
* will not want to set skip unless you're implementing bidiagonalisation.
*/
void apply_hh_left 
( ManifoldMatrix& M, const ManifoldMatrix& v, bool skip = false );

/** compute M * hh(v) , where v is a column vector
*
* Similarly to apply_hh_left, if skip is true, we start at M_j,j+1
*/
void apply_hh_right 
( ManifoldMatrix& M, const ManifoldMatrix& v, bool skip = false );

}
#endif
