#include <transforms.h>

int RUMBA::mosaicX ( int x, int z, int nTilesWide, int tileWidth )
{
	return ( z % nTilesWide ) * tileWidth + x;
}

int RUMBA::mosaicY ( int y, int z, int nTilesWide, int tileHeight )
{
	return ( z / nTilesWide ) * tileHeight + y;
}

int RUMBA::flatToMosaic (int width, int height, int depth, int nTilesWide, int n)
{
	// first get cartesian co-ords
	int x = n%width;
	int y = (n/width)%height;
	int z = (n/(width*height))%depth;

	// co-ordinates in mosaic terms
	int mx = mosaicX (x,z,nTilesWide, width );
	int my = mosaicY (y,z,nTilesWide, height );

	// now flatten them
	return mx + my*width*nTilesWide;
}


