#include <rumba/minchelper.h>
#include <rumba/splodge.h>
#include <map>



typedef map<string, RUMBA::Splodge, less<string> > mid;

/*	
	D is an initialised descriptor 
	result is a >=4d integer array.
*/
void RUMBA::mincSize ( struct netcdfDescriptor D, long* result  )
{
	int i;
	for ( i = 0; i<4; ++i )
	{
		if ( D.dim[i] == MI_ERROR ) {
			result[i] = 1;
		} else {
			ncdiminq ( D.cdf, D.dim[i], 0, &result[i] );
			if ( result[i] == 0 ) 
				result[i] = 1;
		}
		printf ( "%ld\n", result[i] );
	}
}

void RUMBA::mincInitDescriptor ( struct netcdfDescriptor *D )
{
	/* 
		Suppress errors while we query for possibly nonexistent variables --
		we do our own error checking here.
	*/
	int tmp = ncopts;
	ncopts = 0;


	D->dim[0] = ncdimid ( D->cdf, MIxspace );
	D->dim[1] = ncdimid ( D->cdf, MIyspace );
	D->dim[2] = ncdimid ( D->cdf, MIzspace );
	D->dim[3] = ncdimid ( D->cdf, MItime );

	D->image = ncvarid ( D->cdf, MIimage );

	ncopts = tmp;
}

nc_type RUMBA::mincGetDataType ( struct netcdfDescriptor D ) 
{
	nc_type t;
	ncvarinq ( D.cdf, D.image, 0, &t, 0, 0, 0 );
	return t;
}



vector<double> RUMBA::mincGetAttDouble ( int cdfid, int varid, string attname ) 
{
	nc_type t;
	int length = 0;
	int typelength = 0;
	vector<double> v;
	int i;

	/* These could use some error checks ... */
	ncattinq ( cdfid, varid, attname.data(), &t, &length );
	typelength = nctypelen ( t );

	void* ptr = malloc ( typelength * length );
	ncattget ( cdfid, varid, attname.data(), ptr );

	switch ( t )
	{
		case NC_CHAR:
			for ( i = 0; i<length; ++ i ) 
				v.push_back	( (double) ((char*)ptr)[i] 	) ;
			break;
		case NC_SHORT:
			for ( i = 0; i<length; ++ i ) 
				v.push_back	( (double) ((short*)ptr)[i] 	) ;
			break;		
		case NC_LONG:
			for ( i = 0; i<length; ++ i ) 
				v.push_back	( (double) ((int*)ptr)[i] 	) ;
			break;
		case NC_DOUBLE:
			for ( i = 0; i<length; ++ i ) 
				v.push_back	( (double) ((double*)ptr)[i] 	) ;
			break;
		default:
			break;
	}
	free (ptr);
	return v;

}

double RUMBA::mincGetAttDouble1 ( int cdfid, int varid, string attname ) 
{
	nc_type t;
	int length = 0;
	int typelength = 0;
	vector<double> v;
	double result;

	ncattinq ( cdfid, varid, attname.data(), &t, &length );
	typelength = nctypelen ( t );

	if ( length != 1 )
	{
		cerr << "Warning: length is not 1 in mincGetAttDouble1\n";
		return 0;
	}

	void* ptr = malloc ( typelength * length );
	ncattget ( cdfid, varid, attname.data(), ptr );
	
	switch ( t )
	{
		case NC_CHAR:
			result = (double) *((char*)ptr) ;
			break;
		case NC_SHORT:
			result = (double) *((short*)ptr) ;
			break;		
		case NC_LONG:
			result = (double) *((int*)ptr) ;
			break;
		case NC_DOUBLE:
			result = (double) *((double*)ptr) ;
			break;
		default:
			break;
	}
	free (ptr);
	return result;

}

vector<int> RUMBA::mincGetAttInt ( int cdfid, int varid, string attname ) 
{
	nc_type t;
	int length = 0;
	int typelength = 0;
	int i;
	vector<int> v;

	/* These could use some error checks ... */
	ncattinq ( cdfid, varid, attname.data(), &t, &length );
	typelength = nctypelen ( t );

	void* ptr = malloc ( typelength * length );
	ncattget ( cdfid, varid, attname.data(), ptr );
	
	switch ( t )
	{
		case NC_CHAR:
			for ( i = 0; i<length; ++ i ) 
				v.push_back	( (int) ((char*)ptr)[i] 	) ;
			break;
		case NC_SHORT:
			for ( i = 0; i<length; ++ i ) 
				v.push_back	( (int) ((short*)ptr)[i] 	) ;
			break;		
		case NC_LONG:
			for ( i = 0; i<length; ++ i ) 
				v.push_back	( (int) ((int*)ptr)[i] 	) ;
			break;
		case NC_DOUBLE:
			for ( i = 0; i<length; ++ i ) 
				v.push_back	( (int) ((double*)ptr)[i] 	) ;
			break;
		default:
			break;
	}


	free (ptr);
	return v;

}

int RUMBA::mincGetAttInt1 ( int cdfid, int varid, string attname ) 
{
	nc_type t;
	int length = 0;
	int typelength = 0;
	vector<int> v;
	int result;

	ncattinq ( cdfid, varid, attname.data(), &t, &length );
	typelength = nctypelen ( t );

	if ( length != 1 )
	{
		cerr << "Warning: length is not 1 in mincGetAttDouble1\n";
		return 0;
	}

	void* ptr = malloc ( typelength * length );
	ncattget ( cdfid, varid, attname.data(), ptr );

	switch ( t )
	{
		case NC_CHAR:
			result = (int) *((char*)ptr) ;
			break;
		case NC_SHORT:
			result = (int) *((short*)ptr) ;
			break;		
		case NC_LONG:
			result = (int) *((int*)ptr) ;
			break;
		case NC_DOUBLE:
			result = (int) *((double*)ptr) ;
			break;
		default:
			break;
	}
	free (ptr);
	return result;

}

string RUMBA::mincGetAttString ( int cdfid, int varid, string attname ) 
{
	nc_type t;
	int length = 0;
	int typelength = 0;
	string result;

	/* These could use some error checks ... */
	ncattinq ( cdfid, varid, attname.data(), &t, &length );

	if ( t != NC_CHAR )
	{
		cerr << "In mincGetAttString: data type of attribute is not char\n";
		return "";
	}

	/*	t == NC_CHAR	*/
	void* ptr = malloc ( typelength * length );
	typelength = nctypelen ( t );
	ncattget ( cdfid, varid, attname.data(), ptr );
	result = string ((char*)ptr);
	free (ptr);
	return result;
}

RUMBA::Splodge RUMBA::mincGetAtt1 ( int cdfid, int varid, string attname ) 
{
	nc_type t;
	int length = 0;
	int typelength = 0;
	RUMBA::Splodge result;

	ncattinq ( cdfid, varid, attname.data(), &t, &length );
	typelength = nctypelen ( t );

	if ( length != 1 && t != NC_CHAR )
	{
		cerr << "Warning: length is not 1 in mincGetAttDouble1\n";
		return 0;
	}

	void* ptr = malloc ( typelength * length );
	ncattget ( cdfid, varid, attname.data(), ptr );
	
	switch ( t )
	{
		case NC_CHAR:
			result = (char*)ptr;
			break;
		case NC_SHORT:
			result = *((short*)ptr) ;
			break;		
		case NC_LONG:
			result = *((int*)ptr) ;
			break;
		case NC_FLOAT:
			result = *((float*)ptr) ;
		case NC_DOUBLE:
			result = *((double*)ptr) ;
			break;
		default:
			break;
	}
	free (ptr);
	return result;

}

mid RUMBA::loadAtts ( int mincid, int varid )
{
	int i;
	int natts; // number of attributes
	ncvarinq ( mincid, varid, 0, 0, 0, 0, &natts );
	char  attname[ MAX_NC_NAME ];
	mid result;

	for ( i = 0; i< natts; ++i )
	{
		ncattname ( mincid, varid, i, attname );
		result [ attname ] = mincGetAtt1 ( mincid, varid, string(attname) );
	}
	return result;
}
