template<class TYPE>
void RUMBA::Manifold<TYPE>::saveVols( string dirname ) const
{
	mkdir ( dirname.c_str(), S_IRUSR | S_IWUSR | S_IXUSR );
	int i;
	int size;
	ofstream f;
	char filename[256];
	const TYPE *srcDataArray = DataArray;
	ostrstream stream ( filename, 255 );

	for ( i = 0; i < TimePoints; ++i ) 
	{
		// snprintf ( filename, 255, "%d.img", i );
		stream << i << ".img" << '\0';
		if ( chdir ( dirname.c_str() ) ) cerr << "chdir failed" << endl;
		f.open ( filename );
		cerr << "Opening file: " << filename << endl;
		cerr << "i = " << i << endl;

			size = SkipT;
			switch(getDataType()) {
				case TYPE_CHAR: 
					while (size--) putChar(f, *(srcDataArray++)); break;
				case TYPE_SHORT: 
					while (size--) putShort(f, *(srcDataArray++)); break;
				case TYPE_INT: 
					while (size--) putInt(f, *(srcDataArray++)); break;
				case TYPE_FLOAT: 
					while (size--) putFloat(f, *(srcDataArray++)); break;
				case TYPE_DOUBLE: 
					while (size--) putDouble(f, *(srcDataArray++)); break;
				default: 
					cerr << "Manifold::saveVols : unsupported data type\n"; 
					break;
			}
		f.close ();
		// snprintf ( filename, 255, "%d.hdr", i );
		stream << i << ".hdr" << '\0';
		saveAnalyzeHeader ( filename );
	}
}

template <class TYPE>
void RUMBA::Manifold<TYPE>::loadVols ( string directory )
{
	int count = 0;
	list<string>::iterator it;
	Manifold<short> vol;	// vol is a vol.

	list<string> v = RUMBA::ls ( directory );
	assert ( ! v.empty() );

	it = v.begin(); 

	#ifdef DEBUG
	cerr << *it << endl; cerr << BaseManifold::imageType ( *it ) << endl;
	#endif
	// prune the list
	for ( it = v.begin(); it != v.end(); )
		if ( BaseManifold::imageType( *it ) != RUMBA::ANALYZE_DATA )
			it = v.erase ( it );
		else
			++it;
	

	TimePoints = v.size();
	map<int, string > m =  sortFileNames ( v );
  	map< int, string >::const_iterator m_it;
	m_it = m.begin();

	// load header data to fetch dimensions
	vol.load ( directory + "/" + m_it->second, false );

	Height = vol.width();
	Width = vol.height();
	Depth = vol.depth();

	DimX = vol.dimX();
	DimY = vol.dimY();
	DimZ = vol.dimZ();


	delete [] DataArray;
	allocate ( Width, Height, Depth, TimePoints );

//  Now iterate over the map and stuff data into manifold.
	for ( m_it = m.begin(); m_it != m.end(); ++m_it )
	{
		vol = Manifold<short> ( (directory + "/" + m_it->second) );	
		assert ( count < TimePoints );
		set ( vol, 0,0,0,count  );
		count++;
	}

}


// Helper function for loadVols
template <class TYPE>
int RUMBA::Manifold<TYPE>::getFileNumber ( string s )
{
	int i;
	string t = s;

	// remove the file extension.
	t.assign ( t,0, t.find_last_of (".") );

	// remove all characters preceding the last number in the string
	t.assign ( t,  t.find_last_not_of ( "0123456789" ) + 1, t.length() );

	// Extract an integer from the result.
	std::istrstream stream ( t.c_str() );
	stream >> i;

	// Check stream state and possibly throw a tantrum ?

	return i;
}

// Helper function for loadVols
template <class TYPE>
std::map<int,string > RUMBA::Manifold<TYPE>::sortFileNames ( list<string> v ) 
{
	std::map<int,string > result;

	list<string>::const_iterator it;
	for (  it = v.begin(); it !=v.end(); ++it )
		result[ getFileNumber ( *it ) ] = *it;

	
	return result;
}




