#include <rumba/iohandler.h>
#include <rumba/factory.h>

// create instances


std::map<std::string, RUMBA::Factory* > RUMBA::Factory::TypeList;

using std::ios_base;

namespace 
{
class FactoryInit
{
public:	
	FactoryInit()
	{
		RUMBA::CharFactory::get();
		RUMBA::ShortFactory::get();
		RUMBA::IntFactory::get();
		RUMBA::FloatFactory::get();
		RUMBA::DoubleFactory::get();
	}


};
	FactoryInit x;

}

RUMBA::IOHandlerBase* 
RUMBA::CharFactory
::makeIOHandler(const char* name, int Size, ios_base::openmode mode)const 
{ 
	return new IOHandler<char>(name,Size,mode); 
}

RUMBA::IOHandlerBase* 
RUMBA::ShortFactory
::makeIOHandler(const char* name, int Size, ios_base::openmode mode) const { 
	return new IOHandler<short>(name,Size,mode); 
}

RUMBA::IOHandlerBase* 
RUMBA::IntFactory
::makeIOHandler(const char* name, int Size, ios_base::openmode mode) const 
{ 
	return new IOHandler<int>(name,Size,mode); 
}

RUMBA::IOHandlerBase* 
RUMBA::FloatFactory
::makeIOHandler(const char* name, int Size, ios_base::openmode mode)  const 
{ 
	return new IOHandler<float>(name,Size,mode); 
}

RUMBA::IOHandlerBase* 
RUMBA::DoubleFactory
::makeIOHandler(const char* name, int Size, ios_base::openmode mode) const 
{ 
	return new IOHandler<double>(name,Size,mode); 
}
