#ifndef RUMBA_ORIENTATION_IMPL_H
#define RUMBA_ORIENTATION_IMPL_H

#include <rumba/orientation.h>
#include <rumba/manifoldmatrix.h>

namespace RUMBA{ class PermutationTransform; }

RUMBA::PermutationTransform*
buildTransform(const RUMBA::Orientation& o, const RUMBA::intPoint& ext);


// Orientation code needs this definition

namespace RUMBA
{
class OrientationImpl 
{
	// this form takes up more space, but it's also more efficient(?)
	char Rep;
	bool Xyzt;
	intPoint Extent;
public:
	char operator[](int);
	// use matrix wrt x,y,z,t 
	// patient_left, patient_posterior, patient_bottom, xyzt=true
	RUMBA::ManifoldMatrix getMatrix(); 

	OrientationImpl( pdir_t o1, pdir_t o2, pdir_t o3, 
			const intPoint& e, bool b)
	{
		char c[3]; c[0] = o1; c[1] = o2; c[2] = o3;
		Rep = convert_to_char ( c,b );
		Extent = e;
	}

	OrientationImpl( char c )
		: Rep(c)
		{}

	char toChar() const;
	bool xyzt() { return Rep & 64; }

	virtual intPoint extent() const { return Extent; }
	void setExtent(const RUMBA::intPoint& p) { Extent = p; }


	/** 
	  translate between different representations
	 */
	static void convert_to_array ( char c, char* arr, bool* Xyzt );
	static char convert_to_char ( const char*, bool );

	virtual ~OrientationImpl();	
};

}

namespace RUMBA
{
class PointTransformImpl 
{
public:
	virtual void operator() (const RUMBA::intPoint& p, RUMBA::intPoint& q) = 0;
	virtual void map_extent(const RUMBA::intPoint& p, RUMBA::intPoint& q)=0;
	virtual PointTransformImpl* clone() = 0;
	virtual ~PointTransformImpl() = 0;
	virtual PointTransformImpl* compose(const PointTransformImpl*) = 0;

	virtual PointTransformImpl* invert() const = 0;
	virtual void debug() const {}

};
}

// transform of the form f(x) = parity_map ( permutation ( x ) ) 
namespace RUMBA
{
class PermutationTransform : public PointTransformImpl
{
int Rep[4]; // indices we map to
char Parity[4]; // parity transform applied after permutation transform. 1 or -1
intPoint extent; // Determines axes of symmetry for parity flips.
public:
	PermutationTransform();
	PermutationTransform(const int* perm, const char* par, const intPoint& extent);
	void operator() (const intPoint& p, intPoint& q);
	void map_extent (const intPoint& p, intPoint& q);
	PermutationTransform* clone();
	PermutationTransform* invert() const;
	
	PermutationTransform* compose(const PointTransformImpl* t);

	PermutationTransform* compose_impl(const PermutationTransform* t);

	virtual void debug() const
	{
		std::cerr << "DEBUG ---------------" << std::endl;
		std::cerr << "Rep: " << Rep[0] << " " << Rep[1] << " " 
			<< Rep[2] << " " << Rep[3] << std::endl;
		std::cerr << "Parity: " << (int) (Parity[0]) << " " 
			<< (int)(Parity[1]) << " " 
			<< (int)(Parity[2]) << " " << (int)(Parity[3]) << std::endl;
		std::cerr << "Extent: " << extent.x() << "," << extent.y() << ","
			<< extent.z() << "," << extent.t() << std::endl;
		std::cerr << "DEBUG ---------------" << std::endl;
	}

private:
	PermutationTransform(const PermutationTransform& t);


}; //class declaration

} //namespace 


#endif
