#include <rumba/arghandler.h>
#include <rumba/manifold.h>
#include <iostream.h>
#include <strstream.h>

using RUMBA::Argument;
using std::vector;
using std::cerr;
using std::endl;

Argument myArgs [] = {
	Argument ( "type", RUMBA::ALPHA, 't', "" ),
	Argument ("bigendian", RUMBA::FLAG, 'b' ),
	Argument()
};

void help_message();

int main (char argc, char** argv)
{
	RUMBA::BaseManifold* M;	
	istrstream* stream;
	int x,y,z,t;
	string type, outfile;
	vector<string> loose;
	bool le;

	RUMBA::ArgHandler::setRequiredDefaultArg("outfile");


	try 
	{
		RUMBA::ArgHandler argh ( argc, argv, myArgs );
		if (argh.arg("help"))
		{
			help_message();
			return 0;
		}

		argh.arg ( "type", type );
		argh.arg ( "outfile", outfile );
		le = ! argh.arg("bigendian");
		loose = argh.loose();
	}
    catch (RUMBA::MissingArgumentException& s)
    {
		cerr << "Error, missing required argument: " << s.error() << endl;
		help_message();
		return 1;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cerr << "Duplicate argument: " << s.error() << endl;
		help_message();
		return 1;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cerr << "Error: " << s.error() << endl;
		help_message();
		return 1;
	}
	catch ( RUMBA::Exception & e)
	{
		cerr << "Fatal exception " << e.error() << endl;	
		return 1;
	}


	if ( type == "short" || type.empty()  ) 
		M = new RUMBA::Manifold<short>;
	else if ( type == "char" )
		M = new RUMBA::Manifold<char>;
	else if ( type == "int" )
		M = new RUMBA::Manifold<int>;
	else if ( type == "float" )
		M = new RUMBA::Manifold<float>;
	else if ( type == "double" )
		M = new RUMBA::Manifold<double>;
	else
	{
		help_message();
		exit(1);
	}



	if ( loose.empty() )
	{
		help_message();
		exit(1);
	}

	if ( loose.size() != 4 )
	{
		help_message();
		exit(1);
	}


	stream = new istrstream ( loose[0].c_str() );
	*stream >> x;
	if ( ! *stream )
	{
		help_message();
		exit(1);
	}
	delete stream;
	stream = new istrstream ( loose[1].c_str() );
	*stream >> y;
	if ( !*stream )
	{
		help_message();
		exit(1);
	}
	delete stream;
	stream = new istrstream ( loose[2].c_str() );
	*stream >> z;
	if ( !*stream )
	{
		help_message();
		exit(1);
	}
	delete stream;
	stream = new istrstream ( loose[3].c_str() );
	*stream >> t;
	if ( !*stream )
	{
		help_message();
		exit(1);
	}
	delete stream;

	M->setExtent ( RUMBA::intPoint(x,y,z,t) );
	if ( outfile.empty() )
	{
		help_message();
		exit(1);
	}

	if (!le)
		M->setLittleEndian(false);
	M->save ( outfile, false );


}

void help_message()
{
	cerr << "Usage: makeheader -o outfile [ --type char|short|int|float|double ] \
		width height depth timepoints\n";
}
