#! /usr/bin/env ruby
=begin

    demo.rb - rewritten demo.pl in PerlMagick distribution

=end

require "magick"

puts "Read images..."

#
# Create a null image.
#
null = Magick::Image.new
null.set "size"=>"70x70"
null.read "NULL:black"

#
# Create images read from a file.
#
model = Magick::Image.new("model.gif")
model.set("size"=>"70x70")
model.set "bordercolor"=>"black"
model.set "background"=>"black"

smile = Magick::Image.new("smile.gif")
smile.set("bordercolor"=>"black")

#
# Create image stack
#

images = Magick::Image.new

# 1st Row
example = null.dup
images.push example
example = null.dup
images.push example
example = null.dup
images.push example
example = null.dup
images.push example
example = null.dup
images.push example

# add_noise
example = model.dup
example.set "label"=>"add noise"
example.add_noise Magick::NoiseType::Laplacian
images.push example

# annotate
example = model.dup
example.set "label"=>"annotate"
example.annotate "text"=>"Magick","font"=>"Generic.ttf",
                 "geometry"=>"+40+20", "pointsize"=>20,
                 "gravity"=>Magick::GravityType::North,
                 "stroke"=>"firebrick", "fill"=>"gold"
images.push example

# blur
example = model.dup
example.set "label"=>"blur"
example.blur(0.0, 0.1)
images.push example

# border
example = model.dup
example.set "label"=>"border"
example.border "6x6", "gold"
images.push example

# channel
example = model.dup
example.set "label"=>"channel"
example.channel(1)
images.push example

# charcoal
example = model.dup
example.set "label"=>"charcoal"
example.mogrify("","-charcoal","0.0x1.0")
images.push example

# composite
example = model.dup
example.set "label"=>"composite"
example.composite(smile, Magick::CompositeOp::Over, 35, 65)
images.push example

# contrast
example = model.dup
example.set "label"=>"contrast"
example.contrast(true)
images.push example

# cycle_colormap
example = model.dup
example.set "label"=>"cycle colormap"
example.cycle_colormap 1
images.push example


# convolve
example = model.dup
example.set "label"=>"convolve"
example.convolve([1, 1, 1, 1, 4, 1, 1, 1, 1])
images.push example

# clop
example = model.dup
example.set "label"=>"crop"
example.crop("80x80+25+50")
images.push example

# despeckle
example = model.dup
example.set "label"=>"despeckle"
example.despeckle
images.push example

# draw
example = model.dup
example.set "label"=>"draw"
circ = Magick::Drawable::Circle.new(example, 60,90,60,120)
circ.set "stroke"=>"gold", "stroke_width"=>10, "tile"=>smile
example.draw circ
images.push example

# detect edges
example = model.dup
example.set "label"=>"detect edges"
example.edge(0.5)
images.push example

# emboss
example = model.dup
example.set "label"=>"emboss"
example.emboss(0.0, 1.0)
images.push example

# enhance
example = model.dup
example.set "label"=>"enhance"
example.enhance
images.push example

# equalize
example = model.dup
example.set "label"=>"equalize"
example.equalize
images.push example

# explode
example = model.dup
example.set "label"=>"explode", "background"=>"#000000FF"
example.implode(-1.0)
images.push example

# flip
example = model.dup
example.set "label"=>"flip"
example.flip
images.push example

# flop
example = model.dup
example.set "label"=>"flop"
example.flop
images.push example

# frame
example = model.dup
example.set "label"=>"frame"
example.frame
images.push example

# gamma
example = model.dup
example.set "label"=>"gamma"
example.gamma("1.6")
images.push example

# gaussian blur
example = model.dup
example.set "label"=>"gaussian_blur"
example.gaussian_blur(0.0, 1.5)
images.push example

# gradient
gradient = Magick::Image.new
gradient.set "size"=>"130x194"
gradient.read("gradient:#20a0ff-#ffff00")
gradient.set "label"=>"gradient"
images.push gradient

# grayscale
example = model.dup
example.set "label"=>"grayscale"
example.quantize("colorspace"=>Magick::ColorspaceType::GRAY)
images.push example

# implode
example = model.dup
example.set "label"=>"implode"
example.implode 1.0
images.push example

# median filter
example = model.dup
example.set "label"=>"median filter"
example.median_filter 1.0
images.push example

# modulate
example = model.dup
example.set "label"=>"modulate"
example.modulate("110,110,110")

# monochrome
example = model.dup
example.set "label"=>"monochrome"
example.quantize("colorspace"=>Magick::ColorspaceType::GRAY, "dither"=>false, "colors"=>2)
images.push example

# motion_blur
example = model.dup
example.set "label"=>"motion blur"
example.motion_blur(10,10,10)
images.push example

# negate
example = model.dup
example.set "label"=>"negate"
example.negate(false)
images.push example

# normalize
example = model.dup
example.set "label"=>"normalize"
example.normalize
images.push example

# oilpaint
example = model.dup
example.set "label"=>"oilpaint"
example.oilpaint 0.5
images.push example

if Magick::LibVersion >= 0x0532
  # ordered dither
  example = model.dup
  example.set "label"=>"ordered dither"
  example.ordered_dither
  images.push example
end

# plasma
plasma = Magick::Image.new
plasma.set "size"=>"130x194"
plasma.read('plasma:fractal')
plasma.set "label"=>"plasma"
images.push plasma

# quantize
example = model.dup
example.set "label"=>"quantize"
example.quantize "colorspace"=>"CMYK", "colors"=>216
images.push example

# raise
example = model.dup
example.set "label"=>"raise"
example.raise_image("10x10", true)
images.push example

# reduce_noise
example = model.dup
example.set "label"=>"reduce_noise"
example.reduce_noise(1.0)
images.push example

# resize
example = model.dup
example.set "label"=>"resize"
example.resize('50%', Magick::FilterType::Lanczos, 1.0)
images.push example

# roll
example = model.dup
example.set "label"=>"roll"
example.roll(20, 10)
images.push example

# rotate
example = model.dup
example.set "label"=>"rotate"
example.rotate(45)
# example.transparent
images.push example

# scale
example = model.dup
example.set "label"=>"scale"
example.scale('60%')
images.push example

# segment
example = model.dup
example.set "label"=>"segment"
example.segment Magick::ColorspaceType::RGB, false, 1.0, 1.5
images.push example

# shade
example = model.dup
example.set "label"=>"shade"
example.shade false, 50.0, 60.0
images.push example

# shear
example = model.dup
example.set "label"=>"shear"
example.shear 45, 45
#example.transparent
images.push example

# spread
example = model.dup
example.set "label"=>"spread"
example.spread 5
images.push example

# solarize
example = model.dup
example.set "label"=>"solarize"
example.solarize 50.0
images.push example

# swirl
example = model.dup
example.set "background"=>"#000000FF"
example.set "label"=>"swirl"
example.swirl 90
images.push example

# texture
example = model.dup
example.set "label"=>"texture"
example.texture smile
images.push example


# unsharp mask
example = model.dup
example.set "label"=>"unsharp mask"
example.unsharp_mask(0.0, 1.0, 1.0, 0.05)
images.push example

# wave
example = model.dup
example.set "label"=>"wave"
example.set "background"=>"#000000FF"
example.wave(25, 150)
images.push example


# creating the montage image
puts "Montage images..."
m = images.montage({"filename"=>"RubyMagick", "geometry"=>"130x194+10+5>",
                "gravity"=>Magick::GravityType::Center,
                "border_color"=>"green", "border_width"=>1,
                "tile"=>"5x1000", "shadow"=>true,
                "composite"=>Magick::CompositeOp::Over,
                "background_color"=>"#ffffff", "font"=>"Generic.ttf",
                "pointsize"=>18, "fill"=>'#600'})

logo = Magick::Image.new("logo:")
logo.crop('461x455+98+0')
logo.zoom('45%')
m.composite(logo, Magick::CompositeOp::Over, 245, 0)
puts "display images..."
m.display
puts "output to 'demo.jpg'"
m.write("filename"=>"demo.jpg")
