
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_en_scouse/gherkin_lexer_en_scouse.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 20, 21, 22, 41, 42, 43, 
	45, 47, 52, 57, 62, 67, 71, 75, 
	77, 78, 79, 80, 81, 82, 83, 84, 
	85, 86, 87, 88, 89, 90, 91, 92, 
	93, 95, 97, 102, 109, 114, 115, 116, 
	117, 120, 121, 122, 123, 124, 125, 126, 
	127, 128, 129, 130, 131, 132, 133, 134, 
	135, 136, 137, 138, 139, 140, 141, 142, 
	143, 144, 145, 146, 147, 148, 149, 150, 
	151, 152, 153, 154, 155, 171, 173, 175, 
	177, 179, 181, 183, 185, 187, 189, 191, 
	193, 195, 197, 199, 201, 220, 221, 222, 
	223, 224, 225, 226, 227, 228, 229, 230, 
	237, 239, 241, 243, 245, 247, 249, 251, 
	252, 253, 254, 255, 256, 257, 258, 259, 
	260, 272, 274, 276, 278, 280, 282, 284, 
	286, 288, 290, 292, 294, 296, 298, 300, 
	302, 304, 306, 308, 310, 312, 314, 316, 
	318, 320, 322, 324, 326, 328, 330, 332, 
	334, 336, 338, 340, 342, 344, 346, 348, 
	350, 352, 354, 356, 358, 360, 362, 364, 
	366, 368, 370, 372, 374, 376, 378, 380, 
	382, 384, 386, 388, 390, 392, 394, 396, 
	398, 400, 402, 404, 406, 408, 410, 412, 
	414, 416, 418, 419, 420, 421, 422, 423, 
	424, 425, 426, 427, 428, 429, 430, 431, 
	432, 433, 434, 435, 436, 437, 438, 439, 
	440, 441, 457, 459, 461, 463, 465, 467, 
	469, 471, 473, 475, 477, 479, 481, 483, 
	485, 487, 489, 491, 493, 497, 499, 501, 
	503, 505, 507, 509, 511, 513, 515, 517, 
	519, 521, 523, 525, 527, 529, 531, 533, 
	535, 537, 539, 541, 543, 545, 547, 549, 
	551, 553, 555, 557, 559, 561, 563, 565, 
	567, 569, 571, 573, 575, 577, 579, 581, 
	583, 585, 587, 589, 591, 593, 595, 597, 
	599, 601, 603, 605, 607, 609, 611, 613, 
	615, 618, 620, 622, 624, 626, 628, 630, 
	632, 634, 636, 638, 640, 642, 644, 646, 
	648, 650, 652, 654, 657, 659, 661, 663, 
	665, 667, 669, 671, 673, 675, 677, 679, 
	681, 683, 685, 687, 689, 691, 693, 695, 
	697, 699, 700, 701, 702, 703, 704, 705, 
	706, 707, 708, 709, 710, 711, 712, 713, 
	729, 731, 733, 735, 737, 739, 741, 743, 
	745, 747, 749, 751, 753, 755, 757, 759, 
	761, 763, 765, 768, 770, 772, 774, 776, 
	778, 780, 782, 784, 786, 788, 790, 792, 
	794, 796, 798, 800, 802, 804, 806, 808, 
	810, 812, 814, 816, 818, 820, 822, 824, 
	826, 828, 830, 832, 834, 836, 838, 840, 
	842, 844, 846, 848, 850, 852, 854, 856, 
	858, 860, 862, 864, 866, 868, 871, 873, 
	875, 877, 879, 881, 883, 885, 887, 889, 
	891, 893, 895, 897, 899, 901, 903, 905, 
	907, 909, 911, 912, 913, 914, 915, 916, 
	917, 918, 919, 920, 921, 923, 924, 925, 
	926, 927, 928, 929, 930, 931, 932, 933, 
	934, 935, 936, 937, 938, 939, 940, 941, 
	942, 943, 947, 953, 956, 958, 964, 983, 
	985, 987, 989, 992, 994, 996, 998, 1000, 
	1002, 1004, 1006, 1008, 1010, 1012, 1014, 1016, 
	1018, 1020, 1022, 1024, 1026, 1028, 1030, 1032, 
	1034, 1036, 1038, 1040, 1042, 1044, 1046, 1048, 
	1050, 1052, 1054, 1056, 1058, 1060, 1062, 1064, 
	1066, 1068, 1070, 1072, 1075, 1077, 1079, 1081, 
	1083, 1085, 1087, 1089, 1091, 1093, 1095, 1097, 
	1099, 1101, 1103, 1105, 1107, 1109, 1111, 1114, 
	1116, 1118, 1120, 1122, 1124, 1126, 1128, 1130, 
	1132, 1134, 1136, 1138, 1140, 1142, 1144, 1146, 
	1148, 1150, 1152, 1154
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	65, 66, 68, 69, 70, 71, 84, 87, 
	89, 124, 9, 13, -69, -65, 10, 32, 
	34, 35, 37, 42, 64, 65, 66, 68, 
	69, 70, 71, 84, 87, 89, 124, 9, 
	13, 34, 34, 10, 13, 10, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 9, 13, 10, 
	32, 9, 13, 10, 13, 10, 95, 70, 
	69, 65, 84, 85, 82, 69, 95, 69, 
	78, 68, 95, 37, 32, 10, 13, 10, 
	13, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 110, 117, 104, 101, 105, 117, 
	110, 32, 121, 111, 117, 115, 101, 32, 
	103, 111, 116, 116, 97, 115, 32, 105, 
	115, 32, 119, 104, 97, 116, 32, 119, 
	101, 110, 116, 32, 100, 111, 119, 110, 
	58, 10, 10, 10, 32, 35, 37, 42, 
	64, 65, 66, 68, 70, 71, 84, 87, 
	89, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	32, 10, 32, 34, 35, 37, 42, 64, 
	65, 66, 68, 69, 70, 71, 84, 87, 
	89, 124, 9, 13, 120, 97, 109, 112, 
	108, 101, 115, 58, 10, 10, 10, 32, 
	35, 70, 124, 9, 13, 10, 101, 10, 
	97, 10, 116, 10, 117, 10, 114, 10, 
	101, 10, 58, 101, 97, 116, 117, 114, 
	101, 58, 10, 10, 10, 32, 35, 37, 
	64, 68, 69, 70, 84, 87, 9, 13, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, 10, 105, 10, 115, 
	10, 32, 10, 105, 10, 115, 10, 32, 
	10, 119, 10, 104, 10, 97, 10, 116, 
	10, 32, 10, 119, 10, 101, 10, 110, 
	10, 116, 10, 32, 10, 100, 10, 111, 
	10, 119, 10, 110, 10, 58, 10, 120, 
	10, 97, 10, 109, 10, 112, 10, 108, 
	10, 101, 10, 115, 10, 101, 10, 97, 
	10, 116, 10, 117, 10, 114, 10, 101, 
	10, 104, 10, 101, 10, 32, 10, 116, 
	10, 104, 10, 105, 10, 110, 10, 103, 
	10, 32, 10, 111, 10, 102, 10, 32, 
	10, 105, 10, 116, 10, 32, 10, 105, 
	10, 104, 10, 97, 10, 114, 10, 114, 
	10, 105, 10, 109, 10, 101, 10, 97, 
	10, 110, 105, 118, 117, 104, 101, 32, 
	116, 104, 105, 110, 103, 32, 111, 102, 
	32, 105, 116, 32, 105, 115, 58, 10, 
	10, 10, 32, 35, 37, 42, 64, 65, 
	66, 68, 70, 71, 84, 87, 89, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 32, 10, 
	110, 10, 117, 10, 104, 10, 101, 105, 
	117, 10, 110, 10, 32, 10, 121, 10, 
	111, 10, 117, 10, 115, 10, 101, 10, 
	32, 10, 103, 10, 111, 10, 116, 10, 
	116, 10, 97, 10, 115, 10, 32, 10, 
	105, 10, 115, 10, 32, 10, 119, 10, 
	104, 10, 97, 10, 116, 10, 32, 10, 
	119, 10, 101, 10, 110, 10, 116, 10, 
	32, 10, 100, 10, 111, 10, 119, 10, 
	110, 10, 58, 10, 101, 10, 97, 10, 
	116, 10, 117, 10, 114, 10, 101, 10, 
	105, 10, 118, 10, 117, 10, 104, 10, 
	101, 10, 32, 10, 116, 10, 104, 10, 
	105, 10, 110, 10, 103, 10, 32, 10, 
	111, 10, 102, 10, 32, 10, 105, 10, 
	116, 10, 32, 10, 105, 10, 115, 10, 
	104, 117, 10, 97, 10, 114, 10, 114, 
	10, 105, 10, 109, 10, 101, 10, 97, 
	10, 110, 10, 111, 10, 117, 10, 115, 
	10, 101, 10, 32, 10, 107, 10, 110, 
	10, 111, 10, 119, 10, 32, 10, 108, 
	119, 10, 105, 10, 107, 10, 101, 10, 
	32, 10, 119, 10, 104, 10, 101, 10, 
	104, 10, 101, 10, 110, 10, 32, 10, 
	121, 10, 111, 10, 117, 10, 115, 10, 
	101, 10, 32, 10, 103, 10, 111, 10, 
	116, 104, 117, 97, 114, 114, 105, 109, 
	101, 97, 110, 32, 105, 115, 58, 10, 
	10, 10, 32, 35, 37, 42, 64, 65, 
	66, 68, 70, 71, 84, 87, 89, 9, 
	13, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, 10, 32, 10, 
	110, 10, 117, 10, 104, 10, 101, 117, 
	10, 110, 10, 32, 10, 121, 10, 111, 
	10, 117, 10, 115, 10, 101, 10, 32, 
	10, 103, 10, 111, 10, 116, 10, 116, 
	10, 97, 10, 101, 10, 97, 10, 116, 
	10, 117, 10, 114, 10, 101, 10, 58, 
	10, 105, 10, 118, 10, 117, 10, 104, 
	10, 101, 10, 32, 10, 116, 10, 104, 
	10, 105, 10, 110, 10, 103, 10, 32, 
	10, 111, 10, 102, 10, 32, 10, 105, 
	10, 116, 10, 32, 10, 105, 10, 115, 
	10, 111, 10, 117, 10, 115, 10, 101, 
	10, 32, 10, 107, 10, 110, 10, 111, 
	10, 119, 10, 32, 10, 108, 119, 10, 
	105, 10, 107, 10, 101, 10, 32, 10, 
	119, 10, 104, 10, 101, 10, 104, 10, 
	101, 10, 110, 10, 32, 10, 121, 10, 
	111, 10, 117, 10, 115, 10, 101, 10, 
	32, 10, 103, 10, 111, 10, 116, 111, 
	117, 115, 101, 32, 107, 110, 111, 119, 
	32, 108, 119, 105, 107, 101, 32, 119, 
	104, 101, 104, 101, 110, 32, 121, 111, 
	117, 115, 101, 32, 103, 111, 116, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, 10, 32, 34, 35, 
	37, 42, 64, 65, 66, 68, 69, 70, 
	71, 84, 87, 89, 124, 9, 13, 10, 
	110, 10, 117, 10, 104, 10, 101, 117, 
	10, 110, 10, 32, 10, 121, 10, 111, 
	10, 117, 10, 115, 10, 101, 10, 32, 
	10, 103, 10, 111, 10, 116, 10, 116, 
	10, 97, 10, 101, 10, 97, 10, 116, 
	10, 117, 10, 114, 10, 101, 10, 58, 
	10, 105, 10, 118, 10, 117, 10, 104, 
	10, 101, 10, 32, 10, 116, 10, 104, 
	10, 105, 10, 110, 10, 103, 10, 32, 
	10, 111, 10, 102, 10, 32, 10, 105, 
	10, 116, 10, 32, 10, 105, 10, 115, 
	10, 104, 117, 10, 97, 10, 114, 10, 
	114, 10, 105, 10, 109, 10, 101, 10, 
	97, 10, 110, 10, 111, 10, 117, 10, 
	115, 10, 101, 10, 32, 10, 107, 10, 
	110, 10, 111, 10, 119, 10, 32, 10, 
	108, 119, 10, 105, 10, 107, 10, 101, 
	10, 32, 10, 119, 10, 104, 10, 101, 
	10, 104, 10, 101, 10, 110, 10, 32, 
	10, 121, 10, 111, 10, 117, 10, 115, 
	10, 101, 10, 32, 10, 103, 10, 111, 
	10, 116, 0
};

static const char _lexer_single_lengths[] = {
	0, 18, 1, 1, 17, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 1, 1, 1, 
	3, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 14, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 17, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 5, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	10, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 14, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 14, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 4, 3, 2, 4, 17, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 0, 0, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 20, 22, 24, 43, 45, 47, 
	50, 53, 58, 63, 68, 73, 77, 81, 
	84, 86, 88, 90, 92, 94, 96, 98, 
	100, 102, 104, 106, 108, 110, 112, 114, 
	116, 119, 122, 127, 134, 139, 141, 143, 
	145, 149, 151, 153, 155, 157, 159, 161, 
	163, 165, 167, 169, 171, 173, 175, 177, 
	179, 181, 183, 185, 187, 189, 191, 193, 
	195, 197, 199, 201, 203, 205, 207, 209, 
	211, 213, 215, 217, 219, 235, 238, 241, 
	244, 247, 250, 253, 256, 259, 262, 265, 
	268, 271, 274, 277, 280, 299, 301, 303, 
	305, 307, 309, 311, 313, 315, 317, 319, 
	326, 329, 332, 335, 338, 341, 344, 347, 
	349, 351, 353, 355, 357, 359, 361, 363, 
	365, 377, 380, 383, 386, 389, 392, 395, 
	398, 401, 404, 407, 410, 413, 416, 419, 
	422, 425, 428, 431, 434, 437, 440, 443, 
	446, 449, 452, 455, 458, 461, 464, 467, 
	470, 473, 476, 479, 482, 485, 488, 491, 
	494, 497, 500, 503, 506, 509, 512, 515, 
	518, 521, 524, 527, 530, 533, 536, 539, 
	542, 545, 548, 551, 554, 557, 560, 563, 
	566, 569, 572, 575, 578, 581, 584, 587, 
	590, 593, 596, 598, 600, 602, 604, 606, 
	608, 610, 612, 614, 616, 618, 620, 622, 
	624, 626, 628, 630, 632, 634, 636, 638, 
	640, 642, 658, 661, 664, 667, 670, 673, 
	676, 679, 682, 685, 688, 691, 694, 697, 
	700, 703, 706, 709, 712, 717, 720, 723, 
	726, 729, 732, 735, 738, 741, 744, 747, 
	750, 753, 756, 759, 762, 765, 768, 771, 
	774, 777, 780, 783, 786, 789, 792, 795, 
	798, 801, 804, 807, 810, 813, 816, 819, 
	822, 825, 828, 831, 834, 837, 840, 843, 
	846, 849, 852, 855, 858, 861, 864, 867, 
	870, 873, 876, 879, 882, 885, 888, 891, 
	894, 898, 901, 904, 907, 910, 913, 916, 
	919, 922, 925, 928, 931, 934, 937, 940, 
	943, 946, 949, 952, 956, 959, 962, 965, 
	968, 971, 974, 977, 980, 983, 986, 989, 
	992, 995, 998, 1001, 1004, 1007, 1010, 1013, 
	1016, 1019, 1021, 1023, 1025, 1027, 1029, 1031, 
	1033, 1035, 1037, 1039, 1041, 1043, 1045, 1047, 
	1063, 1066, 1069, 1072, 1075, 1078, 1081, 1084, 
	1087, 1090, 1093, 1096, 1099, 1102, 1105, 1108, 
	1111, 1114, 1117, 1121, 1124, 1127, 1130, 1133, 
	1136, 1139, 1142, 1145, 1148, 1151, 1154, 1157, 
	1160, 1163, 1166, 1169, 1172, 1175, 1178, 1181, 
	1184, 1187, 1190, 1193, 1196, 1199, 1202, 1205, 
	1208, 1211, 1214, 1217, 1220, 1223, 1226, 1229, 
	1232, 1235, 1238, 1241, 1244, 1247, 1250, 1253, 
	1256, 1259, 1262, 1265, 1268, 1271, 1275, 1278, 
	1281, 1284, 1287, 1290, 1293, 1296, 1299, 1302, 
	1305, 1308, 1311, 1314, 1317, 1320, 1323, 1326, 
	1329, 1332, 1335, 1337, 1339, 1341, 1343, 1345, 
	1347, 1349, 1351, 1353, 1355, 1358, 1360, 1362, 
	1364, 1366, 1368, 1370, 1372, 1374, 1376, 1378, 
	1380, 1382, 1384, 1386, 1388, 1390, 1392, 1394, 
	1396, 1398, 1402, 1408, 1412, 1415, 1421, 1440, 
	1443, 1446, 1449, 1453, 1456, 1459, 1462, 1465, 
	1468, 1471, 1474, 1477, 1480, 1483, 1486, 1489, 
	1492, 1495, 1498, 1501, 1504, 1507, 1510, 1513, 
	1516, 1519, 1522, 1525, 1528, 1531, 1534, 1537, 
	1540, 1543, 1546, 1549, 1552, 1555, 1558, 1561, 
	1564, 1567, 1570, 1573, 1577, 1580, 1583, 1586, 
	1589, 1592, 1595, 1598, 1601, 1604, 1607, 1610, 
	1613, 1616, 1619, 1622, 1625, 1628, 1631, 1635, 
	1638, 1641, 1644, 1647, 1650, 1653, 1656, 1659, 
	1662, 1665, 1668, 1671, 1674, 1677, 1680, 1683, 
	1686, 1689, 1692, 1695
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 38, 40, 93, 111, 194, 197, 336, 
	442, 473, 4, 0, 3, 0, 4, 0, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	38, 40, 93, 111, 194, 197, 336, 442, 
	473, 4, 0, 6, 0, 7, 0, 9, 
	8, 8, 9, 8, 8, 10, 10, 11, 
	10, 10, 10, 10, 11, 10, 10, 10, 
	10, 12, 10, 10, 10, 10, 13, 10, 
	10, 4, 14, 14, 0, 4, 14, 14, 
	0, 4, 16, 15, 4, 0, 18, 0, 
	19, 0, 20, 0, 21, 0, 22, 0, 
	23, 0, 24, 0, 25, 0, 26, 0, 
	27, 0, 28, 0, 29, 0, 30, 0, 
	563, 0, 32, 0, 4, 16, 33, 4, 
	16, 33, 0, 0, 0, 0, 35, 36, 
	4, 36, 36, 34, 35, 35, 4, 36, 
	34, 36, 0, 31, 0, 39, 0, 31, 
	0, 41, 54, 37, 0, 42, 0, 43, 
	0, 44, 0, 45, 0, 46, 0, 47, 
	0, 48, 0, 49, 0, 50, 0, 51, 
	0, 52, 0, 53, 0, 31, 0, 55, 
	0, 56, 0, 57, 0, 58, 0, 59, 
	0, 60, 0, 61, 0, 62, 0, 63, 
	0, 64, 0, 65, 0, 66, 0, 67, 
	0, 68, 0, 69, 0, 70, 0, 71, 
	0, 72, 0, 73, 0, 74, 0, 76, 
	75, 76, 75, 76, 76, 4, 77, 91, 
	4, 479, 480, 482, 496, 503, 506, 523, 
	532, 76, 75, 76, 78, 75, 76, 79, 
	75, 76, 80, 75, 76, 81, 75, 76, 
	82, 75, 76, 83, 75, 76, 84, 75, 
	76, 85, 75, 76, 86, 75, 76, 87, 
	75, 76, 88, 75, 76, 89, 75, 76, 
	90, 75, 76, 4, 75, 76, 92, 75, 
	4, 4, 5, 15, 17, 31, 34, 37, 
	38, 40, 93, 111, 194, 197, 336, 442, 
	473, 4, 0, 94, 0, 95, 0, 96, 
	0, 97, 0, 98, 0, 99, 0, 100, 
	0, 101, 0, 103, 102, 103, 102, 103, 
	103, 4, 104, 4, 103, 102, 103, 105, 
	102, 103, 106, 102, 103, 107, 102, 103, 
	108, 102, 103, 109, 102, 103, 110, 102, 
	103, 92, 102, 112, 0, 113, 0, 114, 
	0, 115, 0, 116, 0, 117, 0, 118, 
	0, 120, 119, 120, 119, 120, 120, 4, 
	121, 4, 135, 156, 163, 169, 185, 120, 
	119, 120, 122, 119, 120, 123, 119, 120, 
	124, 119, 120, 125, 119, 120, 126, 119, 
	120, 127, 119, 120, 128, 119, 120, 129, 
	119, 120, 130, 119, 120, 131, 119, 120, 
	132, 119, 120, 133, 119, 120, 134, 119, 
	120, 4, 119, 120, 136, 119, 120, 137, 
	119, 120, 138, 119, 120, 139, 119, 120, 
	140, 119, 120, 141, 119, 120, 142, 119, 
	120, 143, 119, 120, 144, 119, 120, 145, 
	119, 120, 146, 119, 120, 147, 119, 120, 
	148, 119, 120, 149, 119, 120, 150, 119, 
	120, 151, 119, 120, 152, 119, 120, 153, 
	119, 120, 154, 119, 120, 155, 119, 120, 
	92, 119, 120, 157, 119, 120, 158, 119, 
	120, 159, 119, 120, 160, 119, 120, 161, 
	119, 120, 162, 119, 120, 155, 119, 120, 
	164, 119, 120, 165, 119, 120, 166, 119, 
	120, 167, 119, 120, 168, 119, 120, 155, 
	119, 120, 170, 119, 120, 171, 119, 120, 
	172, 119, 120, 173, 119, 120, 174, 119, 
	120, 175, 119, 120, 176, 119, 120, 177, 
	119, 120, 178, 119, 120, 179, 119, 120, 
	180, 119, 120, 181, 119, 120, 182, 119, 
	120, 183, 119, 120, 184, 119, 120, 162, 
	119, 120, 186, 119, 120, 187, 119, 120, 
	188, 119, 120, 189, 119, 120, 190, 119, 
	120, 191, 119, 120, 192, 119, 120, 193, 
	119, 120, 183, 119, 195, 0, 196, 0, 
	37, 0, 198, 0, 199, 0, 200, 0, 
	201, 0, 202, 0, 203, 0, 204, 0, 
	205, 0, 206, 0, 207, 0, 208, 0, 
	209, 0, 210, 0, 211, 0, 212, 0, 
	213, 0, 214, 0, 215, 0, 217, 216, 
	217, 216, 217, 217, 4, 218, 232, 4, 
	233, 234, 236, 270, 276, 279, 296, 305, 
	217, 216, 217, 219, 216, 217, 220, 216, 
	217, 221, 216, 217, 222, 216, 217, 223, 
	216, 217, 224, 216, 217, 225, 216, 217, 
	226, 216, 217, 227, 216, 217, 228, 216, 
	217, 229, 216, 217, 230, 216, 217, 231, 
	216, 217, 4, 216, 217, 92, 216, 217, 
	232, 216, 217, 235, 216, 217, 232, 216, 
	217, 237, 250, 233, 216, 217, 238, 216, 
	217, 239, 216, 217, 240, 216, 217, 241, 
	216, 217, 242, 216, 217, 243, 216, 217, 
	244, 216, 217, 245, 216, 217, 246, 216, 
	217, 247, 216, 217, 248, 216, 217, 249, 
	216, 217, 232, 216, 217, 251, 216, 217, 
	252, 216, 217, 253, 216, 217, 254, 216, 
	217, 255, 216, 217, 256, 216, 217, 257, 
	216, 217, 258, 216, 217, 259, 216, 217, 
	260, 216, 217, 261, 216, 217, 262, 216, 
	217, 263, 216, 217, 264, 216, 217, 265, 
	216, 217, 266, 216, 217, 267, 216, 217, 
	268, 216, 217, 269, 216, 217, 92, 216, 
	217, 271, 216, 217, 272, 216, 217, 273, 
	216, 217, 274, 216, 217, 275, 216, 217, 
	269, 216, 217, 277, 216, 217, 278, 216, 
	217, 233, 216, 217, 280, 216, 217, 281, 
	216, 217, 282, 216, 217, 283, 216, 217, 
	284, 216, 217, 285, 216, 217, 286, 216, 
	217, 287, 216, 217, 288, 216, 217, 289, 
	216, 217, 290, 216, 217, 291, 216, 217, 
	292, 216, 217, 293, 216, 217, 294, 216, 
	217, 295, 216, 217, 269, 216, 217, 297, 
	233, 216, 217, 298, 216, 217, 299, 216, 
	217, 300, 216, 217, 301, 216, 217, 302, 
	216, 217, 303, 216, 217, 304, 216, 217, 
	293, 216, 217, 306, 216, 217, 307, 216, 
	217, 308, 216, 217, 309, 216, 217, 310, 
	216, 217, 311, 216, 217, 312, 216, 217, 
	313, 216, 217, 314, 216, 217, 315, 216, 
	217, 316, 323, 216, 217, 317, 216, 217, 
	318, 216, 217, 319, 216, 217, 320, 216, 
	217, 321, 216, 217, 322, 216, 217, 233, 
	216, 217, 324, 216, 217, 325, 216, 217, 
	326, 216, 217, 327, 216, 217, 328, 216, 
	217, 329, 216, 217, 330, 216, 217, 331, 
	216, 217, 332, 216, 217, 333, 216, 217, 
	334, 216, 217, 335, 216, 217, 232, 216, 
	337, 37, 0, 338, 0, 339, 0, 340, 
	0, 341, 0, 342, 0, 343, 0, 344, 
	0, 345, 0, 346, 0, 347, 0, 348, 
	0, 349, 0, 351, 350, 351, 350, 351, 
	351, 4, 352, 366, 4, 367, 368, 370, 
	384, 391, 394, 393, 411, 351, 350, 351, 
	353, 350, 351, 354, 350, 351, 355, 350, 
	351, 356, 350, 351, 357, 350, 351, 358, 
	350, 351, 359, 350, 351, 360, 350, 351, 
	361, 350, 351, 362, 350, 351, 363, 350, 
	351, 364, 350, 351, 365, 350, 351, 4, 
	350, 351, 92, 350, 351, 366, 350, 351, 
	369, 350, 351, 366, 350, 351, 371, 367, 
	350, 351, 372, 350, 351, 373, 350, 351, 
	374, 350, 351, 375, 350, 351, 376, 350, 
	351, 377, 350, 351, 378, 350, 351, 379, 
	350, 351, 380, 350, 351, 381, 350, 351, 
	382, 350, 351, 383, 350, 351, 366, 350, 
	351, 385, 350, 351, 386, 350, 351, 387, 
	350, 351, 388, 350, 351, 389, 350, 351, 
	390, 350, 351, 92, 350, 351, 392, 350, 
	351, 393, 350, 351, 367, 350, 351, 395, 
	350, 351, 396, 350, 351, 397, 350, 351, 
	398, 350, 351, 399, 350, 351, 400, 350, 
	351, 401, 350, 351, 402, 350, 351, 403, 
	350, 351, 404, 350, 351, 405, 350, 351, 
	406, 350, 351, 407, 350, 351, 408, 350, 
	351, 409, 350, 351, 410, 350, 351, 390, 
	350, 351, 412, 350, 351, 413, 350, 351, 
	414, 350, 351, 415, 350, 351, 416, 350, 
	351, 417, 350, 351, 418, 350, 351, 419, 
	350, 351, 420, 350, 351, 421, 350, 351, 
	422, 429, 350, 351, 423, 350, 351, 424, 
	350, 351, 425, 350, 351, 426, 350, 351, 
	427, 350, 351, 428, 350, 351, 367, 350, 
	351, 430, 350, 351, 431, 350, 351, 432, 
	350, 351, 433, 350, 351, 434, 350, 351, 
	435, 350, 351, 436, 350, 351, 437, 350, 
	351, 438, 350, 351, 439, 350, 351, 440, 
	350, 351, 441, 350, 351, 366, 350, 443, 
	0, 444, 0, 445, 0, 446, 0, 447, 
	0, 448, 0, 449, 0, 450, 0, 451, 
	0, 452, 0, 453, 460, 0, 454, 0, 
	455, 0, 456, 0, 457, 0, 458, 0, 
	459, 0, 37, 0, 461, 0, 462, 0, 
	463, 0, 464, 0, 465, 0, 466, 0, 
	467, 0, 468, 0, 469, 0, 470, 0, 
	471, 0, 472, 0, 31, 0, 473, 474, 
	473, 0, 478, 477, 476, 474, 477, 475, 
	0, 476, 474, 475, 0, 476, 475, 478, 
	477, 476, 474, 477, 475, 478, 478, 5, 
	15, 17, 31, 34, 37, 38, 40, 93, 
	111, 194, 197, 336, 442, 473, 478, 0, 
	76, 91, 75, 76, 481, 75, 76, 91, 
	75, 76, 483, 479, 75, 76, 484, 75, 
	76, 485, 75, 76, 486, 75, 76, 487, 
	75, 76, 488, 75, 76, 489, 75, 76, 
	490, 75, 76, 491, 75, 76, 492, 75, 
	76, 493, 75, 76, 494, 75, 76, 495, 
	75, 76, 91, 75, 76, 497, 75, 76, 
	498, 75, 76, 499, 75, 76, 500, 75, 
	76, 501, 75, 76, 502, 75, 76, 92, 
	75, 76, 504, 75, 76, 505, 75, 76, 
	479, 75, 76, 507, 75, 76, 508, 75, 
	76, 509, 75, 76, 510, 75, 76, 511, 
	75, 76, 512, 75, 76, 513, 75, 76, 
	514, 75, 76, 515, 75, 76, 516, 75, 
	76, 517, 75, 76, 518, 75, 76, 519, 
	75, 76, 520, 75, 76, 521, 75, 76, 
	522, 75, 76, 502, 75, 76, 524, 479, 
	75, 76, 525, 75, 76, 526, 75, 76, 
	527, 75, 76, 528, 75, 76, 529, 75, 
	76, 530, 75, 76, 531, 75, 76, 520, 
	75, 76, 533, 75, 76, 534, 75, 76, 
	535, 75, 76, 536, 75, 76, 537, 75, 
	76, 538, 75, 76, 539, 75, 76, 540, 
	75, 76, 541, 75, 76, 542, 75, 76, 
	543, 550, 75, 76, 544, 75, 76, 545, 
	75, 76, 546, 75, 76, 547, 75, 76, 
	548, 75, 76, 549, 75, 76, 479, 75, 
	76, 551, 75, 76, 552, 75, 76, 553, 
	75, 76, 554, 75, 76, 555, 75, 76, 
	556, 75, 76, 557, 75, 76, 558, 75, 
	76, 559, 75, 76, 560, 75, 76, 561, 
	75, 76, 562, 75, 76, 91, 75, 0, 
	0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	29, 35, 0, 43, 0, 43, 0, 43, 
	54, 0, 5, 1, 0, 29, 1, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 
	35, 0, 43, 0, 43, 0, 43, 139, 
	48, 9, 106, 11, 0, 134, 45, 45, 
	45, 3, 122, 33, 33, 33, 0, 122, 
	33, 33, 33, 0, 122, 33, 0, 33, 
	0, 102, 7, 7, 43, 54, 0, 0, 
	43, 114, 25, 0, 54, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 149, 126, 57, 110, 
	23, 0, 43, 43, 43, 43, 0, 27, 
	118, 27, 27, 51, 27, 0, 54, 0, 
	1, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 54, 0, 72, 33, 84, 
	72, 84, 84, 84, 84, 84, 84, 84, 
	84, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 54, 15, 0, 
	130, 31, 60, 57, 31, 63, 57, 63, 
	63, 63, 63, 63, 63, 63, 63, 63, 
	66, 31, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 81, 84, 81, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 21, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 54, 0, 69, 
	33, 69, 84, 84, 84, 84, 84, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 13, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	13, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 144, 57, 
	54, 0, 54, 0, 75, 33, 84, 75, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 17, 0, 54, 17, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 17, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 54, 
	0, 78, 33, 84, 78, 84, 84, 84, 
	84, 84, 84, 84, 84, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 19, 
	0, 54, 19, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 19, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	0, 43, 54, 37, 37, 87, 37, 37, 
	43, 0, 39, 0, 43, 0, 0, 54, 
	0, 0, 39, 0, 0, 54, 0, 93, 
	90, 41, 96, 90, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 99, 0, 43, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 563;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1238 "ext/gherkin_lexer_en_scouse/gherkin_lexer_en_scouse.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
    
#line 1245 "ext/gherkin_lexer_en_scouse/gherkin_lexer_en_scouse.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1535 "ext/gherkin_lexer_en_scouse/gherkin_lexer_en_scouse.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1598 "ext/gherkin_lexer_en_scouse/gherkin_lexer_en_scouse.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/en_scouse.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_en_scouse()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "En_scouse", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

