<?xml version="1.0" ?>

<!-- 	 
############################################################################################## 
############################################################################################## 
## 
##	Nome: rub2rub.xsl 
##	versione: 0.2  
##	Copyright (C) 2000-2002 Nicola Fragale <nicolafragale@libero.it> 
##	
##	Scopo: tradurre i file generati da una vecchia versione di Rubrica (.rub)  
##             nel formato adottato dall'ultima versione 
##    
##	This program is free software; you can redistribute it and/or modify 
##	it under the terms of the GNU General Public License as published by 
## 	the Free Software Foundation; either version 2 of the License, or 
##  	(at your option) any later version. 
##
## 	This program is distributed in the hope that it will be useful, 
##  	but WITHOUT ANY WARRANTY; without even the implied warranty of 
##  	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
##  	GNU General Public License for more details. 
##
##  	You should have received a copy of the GNU General Public License 
##  	along with this program; if not, write to the Free Software 
##  	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
##  	
############################################################################################# 
############################################################################################# 
--> 
	
	<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">	

		<xsl:template match="Rubrica">
			<Rubrica version="1.0.12" fileformat="3">
				<xsl:apply-templates/>
			</Rubrica>
		</xsl:template>		
		
		
		<!-- importa i dati da "Card" => formato file 2 
		     ed esporta a "Card" formato file 3 
		--> 
		<xsl:template match="Card"> 		
			<Card name="{./@name}" deleting="{./@deleting}" group="{./@group}"   
				created="{./@created}" last_change="{./@last_change}"> 
				&#13; &#10; 			  
				 	<xsl:apply-templates select="Data"/>   
				  	<xsl:apply-templates select="Address"/>   
				  	<xsl:apply-templates select="WebAddresses"/>   
				  	<xsl:apply-templates select="EmailAddresses"/>    
			 	 	<xsl:apply-templates select="TelephoneNumbers"/>    
			  		<xsl:apply-templates select="Company"/>    
			  		<xsl:apply-templates select="Work"/>   
				  	<xsl:apply-templates select="Notes"/>  
			</Card>   &#10; &#13; 			
		</xsl:template>

		<!-- importa i dati da "Indirizzo" => formato file 1 
		     ed esporta a "Card" formato file 3
		--> 	 
		<xsl:template match="Indirizzo">
			<Card name="{./Scheda}" deleting="{./Scheda/@cancellabile}"	
			      group="" created="0" last_change="0"> &#13; &#10; 
			      
			 	<xsl:apply-templates select="Dati"/> 
			  	<xsl:apply-templates select="IndirizziWeb"/> 
			   	<xsl:apply-templates select="IndirizziEmail"/> 
			    	<xsl:apply-templates select="NumeriTelefonici"/> 

			     	<Company> &#10; &#13;
			      		<CompanyName></CompanyName> &#10; &#13;
			      		<Street></Street> &#10; &#13;
	      				<StreetNumber></StreetNumber> &#10; &#13;
	      				<ZipCode></ZipCode> &#10; &#13;
		      			<City></City> &#10; &#13;
			      		<Province></Province> &#10; &#13;
		      			<Country></Country> &#10; &#13;
	      				<Web></Web> &#10; &#13;
		      			<Email></Email> &#10; &#13;
		      			<Operator></Operator> &#10; &#13;
		      			<Fax></Fax> &#10; &#13;
		      			<Green></Green> &#10; &#13;
			      		<CustomerCare></CustomerCare> &#10; &#13;
		      			<Notes></Notes> &#10; &#13;
				</Company> &#10; &#13;	
				
				<Work> &#10; &#13;
			 		<Assigment></Assigment> &#10; &#13;
			   		<Organization></Organization> &#10; &#13;
			     		<Department></Department> &#10; &#13;
			      		<SubDepartment></SubDepartment> &#10; &#13;
	      				<SecretaryName></SecretaryName> &#10; &#13;
			      		<Secretaryphone></Secretaryphone> &#10; &#13;
	      			</Work> &#10; &#13;
			      	
	      			<Notes married="false" children="false" know_birthday="false" 
					know_anniversary="false"> &#10; &#13;
					<SpouseName birthday="0" anniversary="0"></SpouseName> 
					 &#10; &#13;
				 	<Child></Child>  &#10; &#13;
			 		<Hobbies></Hobbies>  &#10; &#13;
			 		<OtherNotes>  &#10; &#13;
						<xsl:apply-templates select="Note"/> 
						&#10; &#13;
					</OtherNotes>  &#10; &#13;
					<PublicKey></PublicKey>  &#10; &#13;
				</Notes>  &#10; &#13;				
							 	 		
			</Card>  &#10; &#13;
		</xsl:template>
		

		
		<!-- import templates 
		-->

		<!-- template per importare il formato file 1 
		  -->
		<xsl:template match="Dati"> 
			<Data> &#10; &#13;
				<FirstName know_birthday="false" birthday="0"> &#10; &#13;
					<xsl:value-of select="Nome"/> &#10; &#13;
				</FirstName> &#10; &#13;
	      				      			
	   			<MiddleName></MiddleName> &#10; &#13;
	      			
				<LastName> &#10; &#13;
					<xsl:value-of select="Cognome"/> &#10; &#13;
				</LastName> &#10; &#13;
	      			
				<Profession> &#10; &#13;
					<xsl:value-of select="Professione"/> &#10; &#13;
     				</Profession> &#10; &#13;
	      			
     				<NamePrefix></NamePrefix> &#10; &#13;
     				<Title></Title> &#10; &#13;
			</Data> &#10; &#13;
	      		
     			<Address> &#10; &#13;
	    			<Street> &#10; &#13;
     					<xsl:value-of select="Via"/> &#10; &#13;
     				</Street> &#10; &#13;
	      			
     				<StreetNumber>  &#10; &#13;
     					<xsl:value-of select="Numero"/>  &#10; &#13;
	     			</StreetNumber>	&#10; &#13; 		 
		      			
     				<ZipCode>  &#10; &#13;
					<xsl:value-of select="Cap"/>  &#10; &#13;
				</ZipCode>  &#10; &#13;
				
				<City>  &#10; &#13;
					<xsl:value-of select="Citta"/>  &#10; &#13;
				</City>  &#10; &#13;
	
				<Province>  &#10; &#13;
					<xsl:value-of select="Provincia"/>  &#10; &#13;
				</Province>  &#10; &#13;
	
				<State></State> &#10; &#13;
				
				<Country>  &#10; &#13;
					<xsl:value-of select="Stato"/>  &#10; &#13;
				</Country> &#10; &#13;			     
	  		</Address>  &#10; &#13;
		</xsl:template>  <!-- Data template -->


		<xsl:template match="IndirizziWeb">
			<WebAddresses> &#10; &#13;
				<Web> &#10; &#13;
					<xsl:apply-templates select="Web"/>
				</Web> &#10; &#13;
			</WebAddresses> &#10; &#13;
		</xsl:template>
		

		<xsl:template match="Web"> 
			<xsl:value-of select="."/> &#10; &#13; 
		</xsl:template>
		
		
		<xsl:template match="IndirizziEmail">  
			<EmailAddresses> &#10; &#13;
				<Email> &#10; &#13;
					<xsl:apply-templates select="EMail"/>
				</Email> &#10; &#13;
			</EmailAddresses>	      	
		</xsl:template>
		
	      
		<xsl:template match="EMail"> 
			<xsl:value-of select="."/> &#10; &#13;
		</xsl:template>
		
		
		<xsl:template match="NumeriTelefonici">
			<TelephoneNumbers> &#10; &#13;
				<xsl:apply-templates select="Telefono"/>
			</TelephoneNumbers> &#10; &#13;
		</xsl:template>
		
		
		<xsl:template match="Telefono"> 
			<xsl:variable name="telephonetype">
				<xsl:if test="./@Tipo='Casa' or ./@Tipo='Home'">
					home
				</xsl:if>
				
				<xsl:if test="./@Tipo='Ufficio' or ./@Tipo='Work'">
					work
				</xsl:if>
				
				<xsl:if test="./@Tipo='Fax'">
					fax
				</xsl:if>
				
				<xsl:if test="./@Tipo='Cellulare' or ./@Tipo='Cellphone'">
					cellphone
				</xsl:if>	
										
				<xsl:if test="./@Tipo='Altro' or ./@Tipo='Other'">
					other
				</xsl:if>
			</xsl:variable>
			
			
			<Telephone type="{$telephonetype}">
				<xsl:value-of select="."/>
			</Telephone>			
		</xsl:template> 
	    
	    
		<xsl:template match="Note">
	 		<xsl:value-of select="."/>
	 	</xsl:template>
	 	
	 	
		<!-- template per importare il formato file 2 -->	
		<xsl:template match="Data">
			<Data>
				<FirstName know_birthday="{./FirstName/@know_birthday}" 
					birthday="{./FirstName/@birthday}"> &#10; &#13;
					<xsl:value-of select="FirstName"/> &#10; &#13; 
				</FirstName> &#10; &#13; 
	      				      			
 	 			<MiddleName>
  					<xsl:value-of select="MiddleName"/> &#10; &#13;
  				</MiddleName> &#10; &#13;
	      			
				<LastName> &#10; &#13;
					<xsl:value-of select="LastName"/> &#10; &#13;
				</LastName> &#10; &#13;
	      			
				<Profession> &#10; &#13;
					<xsl:value-of select="Profession"/> &#10; &#13; 
	  			</Profession> &#10; &#13;
	      			
 	 			<NamePrefix>
 		 			<xsl:value-of select="NamePrefix"/> &#10; &#13; 
  				</NamePrefix> &#10; &#13;
  			
  				<Title>
	  				<xsl:value-of select="Title"/> &#10; &#13; 
	  			</Title> &#10; &#13;
			</Data>	
		</xsl:template>
		
		
		<xsl:template match="Address">
			<Address>
	  			<Street> &#10; &#13;
 	 				<xsl:value-of select="Street"/> &#10; &#13;
  				</Street> &#10; &#13;
	      			
  				<StreetNumber>  &#10; &#13;
  					<xsl:value-of select="StreetNumber"/>  &#10; &#13;
  				</StreetNumber>	&#10; &#13; 		 
	      			
	  			<ZipCode>  &#10; &#13;
					<xsl:value-of select="ZipCode"/>  &#10; &#13;
				</ZipCode>  &#10; &#13;
				
				<City>  &#10; &#13;
					<xsl:value-of select="City"/>  &#10; &#13;
				</City>  &#10; &#13;
		
				<Province>  &#10; &#13;
					<xsl:value-of select="Province"/>  &#10; &#13;
				</Province>  &#10; &#13;
		
				<State>
					<xsl:value-of select="State"/> &#10; &#13;
				</State> &#10; &#13;
				
				<Country>  &#10; &#13;
					<xsl:value-of select="Country"/>  &#10; &#13;
				</Country> &#10; &#13;
			</Address>
		</xsl:template>
		
		
		<xsl:template match="WebAddresses"> 
			<WebAddresses> &#10; &#13; 
				<xsl:apply-templates select="Web"/> &#10; &#13;
			</WebAddresses> &#10; &#13; 
		</xsl:template> 
		

		<xsl:template match="Web"> 
			<Web> &#10; &#13; 
				<xsl:value-of select="."/> &#10; &#13; 
			</Web> &#10; &#13; 
		</xsl:template>
		
				
		<xsl:template match="EmailAddresses"> 
			<EmailAddresses> &#10; &#13; 			
				<xsl:apply-templates select="Email"/> &#10; &#13;
			</EmailAddresses>	   	 	
		</xsl:template>				 
		
				
		<xsl:template match="Email">
			<Email> &#10; &#13;  
				<xsl:value-of select="."/> &#10; &#13;
			</Email> &#10; &#13; 	
		</xsl:template>			
		
		
		<xsl:template match="TelephoneNumbers"> 
			<TelephoneNumbers> &#10; &#13; 
				<xsl:apply-templates select="Telephone"/> &#10; &#13;
			</TelephoneNumbers> &#10; &#13; 
		</xsl:template> 
		
		
		<xsl:template match="Telephone"> 
			<xsl:variable name="type"> 
				<xsl:if test="./@type='home'">home</xsl:if> 
				
				<xsl:if test="./@type='work'">work</xsl:if> 
				
				<xsl:if test="./@type='fax'">fax</xsl:if> 
				
				<xsl:if test="./@type='cellphone'">cellphone</xsl:if>	 
										
				<xsl:if test="./@type='other'">other</xsl:if> 
			</xsl:variable> 
			
			<Telephone type="{$type}"> 
				<xsl:value-of select="."/> 
			</Telephone>		 
		</xsl:template> 
		
		
		<xsl:template match="Company">
	     	<Company> &#10; &#13;
		  		<CompanyName>
		  			<xsl:value-of select="CompanyName"/>  &#10; &#13;
		  		</CompanyName> &#10; &#13;
		  		<Street>
		  			<xsl:value-of select="Street"/>  &#10; &#13;
		  		</Street> &#10; &#13;
	 	 		<StreetNumber>
		  			<xsl:value-of select="StreetNumber"/>  &#10; &#13;
	 	 		</StreetNumber> &#10; &#13;
	  			<ZipCode>
		  			<xsl:value-of select="ZipCode"/>  &#10; &#13;
	  			</ZipCode> &#10; &#13;
	  			<City>
		  			<xsl:value-of select="City"/>  &#10; &#13;
	  			</City> &#10; &#13;
	  			<Province>
		  			<xsl:value-of select="Province"/>  &#10; &#13;
	  			</Province> &#10; &#13;
		  		<Country>
		  			<xsl:value-of select="Country"/>  &#10; &#13;
		  		</Country> &#10; &#13;
		  		<Web>
		  			<xsl:value-of select="Web"/>  &#10; &#13;
		  		</Web> &#10; &#13;
	 	 		<Email>
		  			<xsl:value-of select="Email"/>  &#10; &#13;
	 	 		</Email> &#10; &#13;
	  			<Operator>
		  			<xsl:value-of select="Operator"/>  &#10; &#13;
	  			</Operator> &#10; &#13;
	  			<Fax>
		  			<xsl:value-of select="Fax"/>  &#10; &#13;
	  			</Fax> &#10; &#13;
	  			<Green>
		  			<xsl:value-of select="Green"/>  &#10; &#13;
	  			</Green> &#10; &#13;
		  		<CustomerCare>
		  			<xsl:value-of select="CustomerCare"/>  &#10; &#13;
		  		</CustomerCare> &#10; &#13;
		  		<Notes>
		  			<xsl:value-of select="Notes"/>  &#10; &#13;
		  		</Notes> &#10; &#13;
			</Company> &#10; &#13;	
		</xsl:template>
		
				
		<xsl:template match="Work">
			<Work> &#10; &#13;
		 		<Assigment>
		 			<xsl:value-of select="Assigment"/>  &#10; &#13;
		 		</Assigment> &#10; &#13;

		   		<Organization>
	   				<xsl:value-of select="Organization"/>  &#10; &#13;
				</Organization> &#10; &#13;

	      			<Department>		 			
		      			<xsl:value-of select="Department"/>  &#10; &#13;
				</Department> &#10; &#13;

      				<SubDepartment>		 			
		      			<xsl:value-of select="SubDepartment"/>  &#10; &#13;
				</SubDepartment> &#10; &#13;

		      		<SecretaryName>		 			
    			  		<xsl:value-of select="SecretaryName"/>  &#10; &#13;
				</SecretaryName> &#10; &#13;

		      		<Secretaryphone>		 			
    			  		<xsl:value-of select="Secretaryphone"/>  &#10; &#13;
				</Secretaryphone> &#10; &#13;
			</Work>  &#10; &#13; 
      </xsl:template>		      			      


		<xsl:template match="Notes">
			<Notes married="{./@married}" children="{./@children}"  
				know_birthday="true" know_anniversary="true"> &#10; &#13; 
				<SpouseName birthday="{./SpouseName/@birthday}" 
					anniversary="{./SpouseName/@anniversary}">
					<xsl:value-of select="SpouseName"/> &#10; &#13;
				</SpouseName>  &#10; &#13;

			 	<Child>
					<xsl:value-of select="Child"/>  &#10; &#13;
			 	</Child>  &#10; &#13;

		 		<Hobbies>
					<xsl:value-of select="Hobbies"/>  &#10; &#13;
		 		</Hobbies>  &#10; &#13;

		 		<OtherNotes>  &#10; &#13;
					<xsl:apply-templates select="OtherNotes"/> &#10; &#13;
				</OtherNotes>  &#10; &#13;

				<PublicKey>
					<xsl:value-of select="PublicKey"/>  &#10; &#13;
				</PublicKey>  &#10; &#13;			
			</Notes>   &#10; &#13;	
		</xsl:template>
 	
	</xsl:stylesheet>

	<!-- 	end of file
	-->
