# BEGIN LICENSE BLOCK
# 
#  Copyright (c) 2002-2003 Jesse Vincent <jesse@bestpractical.com>
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of version 2 of the GNU General Public License 
#  as published by the Free Software Foundation.
# 
#  A copy of that license should have arrived with this
#  software, but in any event can be snarfed from www.gnu.org.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
# END LICENSE BLOCK

# $Header: /raid/cvsroot/fm/lib/RT/FM/CustomFieldObjectValueCollection.pm,v 1.1 2001/08/29 05:56:04 jesse Exp $
# Autogenerated by DBIx::SearchBuilder factory  (by <jesse@fsck.com>)

=head1 NAME

  RT::FM::CustomFieldObjectValueCollection -- Class Description
 
=head1 SYNOPSIS

  use RT::FM::CustomFieldObjectValueCollection

=head1 DESCRIPTION


=head1 METHODS

=cut

package RT::FM::CustomFieldObjectValueCollection;

use RT::FM::SearchBuilder;
use RT::FM::CustomFieldObjectValue;

@ISA= qw(RT::FM::SearchBuilder);


sub _Init {
    my $self = shift;
    $self->{'table'} = 'CustomFieldObjectValues';
    $self->{'primary_key'} = 'id';
    return ( $self->SUPER::_Init(@_) );
}


=item LimitToCustomField CFID

Limit the returned set of results to the custom field with id CFID

=cut

sub LimitToCustomField {
	my $self = shift;
	my $customfield = shift;
	$self ->Limit( 	FIELD => 'CustomField',
			OPERATOR => '=',
			VALUE => $customfield);
}


=item LimitToArticle ARTICLEID

Limit the returned set of results to the article with id ARTICLEID

=cut

sub LimitToArticle {
	my $self = shift;
	my $article = shift;
	$self ->Limit( 	FIELD => 'Article',
			OPERATOR => '=',
			VALUE => $article);
}



=item NewItem

Returns an empty new RT::FM::CustomFieldObjectValue item

=cut

sub NewItem {
    my $self = shift;
    return(new RT::FM::CustomFieldObjectValue(@_));
}

1;
