#|------------------------------------------------------------*-Scheme-*--|
 | File:	    packages/rstore/module.scm
 |
 |          Copyright (C)1998 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |	    See <http://www.rscheme.org/> for the latest info.
 |
 | File version:     1.11
 | File mod date:    2004-02-24 09:49:41
 | System build:     v0.7.3.3-b20u, 2004-04-02
 | Owned by module:  rs.db.rstore
 |
 | Purpose:          Module control file
 `------------------------------------------------------------------------|#

(define-module rs.db.rstore ()
  (&module
   (import rs.lang)
   (import rs.lang.internal)
   (import rs.sys.paths)
   (import rs.sys.tables)
   (import rs.db.lss)
   (import rs.glue)
   (import rs.sys.linker)
   (import sort))
  ;
#| -- can't make this work yet for `rsc' -- see CR 771
  (&module (import rs.util.msgs))
  (define-message-table rs.db.rstore 463)

  #- rs.db.rstore/debug (define-macro (dm . opts) (values))
|#

  (define-macro (dm . opts)
    (values))
#|
    (if (number? (car opts))
        `(format #t ,(format #f "463-~03dD ~a\n" (car opts) (cadr opts))
                 ,@(cddr opts))
        `(format #t ,(format #f "463-000D ~a\n" (car opts)) ,@(cdr opts)))
|#
  (define-macro (em num msg . opts)
    `(error ,(format #f "463-~03dE ~a" num msg) ,@opts))

  (&module
   ;;
   (load "../lss/glue.scm")
   (load "glue.scm")
   (load "pstore.scm")
   (load "copyin.scm")
   (load "indir.scm")
   (load "commit.scm")
   ;;
   (export register-pivot!
           extend-named-pivot-index!
           get-named-pivots)
   ;;
   (export open-persistent-store
	   create-persistent-store
	   read-persistent-store
	   close-persistent-store
           open-pstore-on-lss
           lss-tune
	   commit
	   set-compression-method!
	   root-object
           copy-into-pstore
	   set-root-object!
	   register-indirect-page
	   default-allocation-area
	   
	   num-dirty-pages
	   rollback-dirty-pages
	   object->allocation-area
	   <persistent-store>
	   make-allocation-area
           allocation-area->store
           object-deallocate
           location-deallocate)

   (export transient->persistent
           persistent->parts
           parts->persistent
           persistent->transient)

   (export pstore-meta-scan-pagetable
           pstore-meta-scan-starts
           pstore-meta-scan-objects
           pstore-meta-scan-npages
           pstore-meta-identify-rich-model
           pstore-meta-std-indirects
           pstore-meta-insert-indirects
           pstore-meta-scan-first-pp
           pstore-meta-scan-interior-pp)
   ;;
   (load "gc.scm")
   (export pstore-gc-initiate-cycle
           pstore-gc-resume-cycle
           pstore-gc-process
           pstore-gc-finalize
           pstore-gc-full                   ; do a full GC
           ;;
           start-online-compacter       ; does work on `commit' of pstore
           fuel-online-compaction!      ; to do extra work
           print-compaction-status)))
    
