
(define (create-cursor #key (source type: <x-pixmap>)
		            (mask default: #f)
		            x y
			    (foreground type: <color>)
			    (background type: <color>))
  (let ((id (alloc-x-id (x-display source))))
    (internal-send
     (x-display source)
     (make-buffer u1: 93  ; CreateCursor
		  u1: 0
		  u2: 8
		  u4: id
		  u4: (x-id source)
		  u4: (if mask (x-id mask) 0)
		  u2: (red-component foreground)
		  u2: (green-component foreground)
		  u2: (blue-component foreground)
		  u2: (red-component background)
		  u2: (green-component background)
		  u2: (blue-component background)
		  u2: x
		  u2: y))
    (make <x-cursor>
	  x-display: (x-display source)
	  x-id: id)))

	  
