
(define parse-rgbi (unformat->proc "rgbi:~d/~d/~d"))

(%early-once-only

(define *named-colors* (make-string-ci-table))
(table-insert! *named-colors* "black" $black)
(table-insert! *named-colors* "white" $white)
(table-insert! *named-colors* "gray50" (make-color red: 0.5
						   green: 0.5
						   blue: 0.5))

)


(define (named-color->color str)
  (table-lookup *named-colors* str))

(define (rgbi-string->color str)
  (bind ((r g b (parse-rgbi str)))
    (if r
	(make-color red: r green: g blue: b)
	#f)))

(define (string->color (str <string>))
  (or (rgbi-string->color str)
      (named-color->color str)))

(define-method to-string ((self <color>))
  ;; `rgbi:r/g/b' is a recent X color spec standard
  (format #f "rgbi:~d/~d/~d"
	  (color-red self)
	  (color-green self)
	  (color-blue self)))

(define-method to-string ((self <pixel>))
  (format #f "rgbai:~d/~d/~d/~d"
	  (color-red self)
	  (color-green self)
	  (color-blue self)
	  (pixel-alpha self)))
