(define key-pattern (reg-expr->proc '(seq #\% alpha #\%)))

(define (expand-keys (text <string>) keylist)
  (call-with-output-string
   (lambda (port)
     (let loop ((i 0))
       (bind ((s e (key-pattern text i)))
	 (if s
	     (begin
	       (write-string port (substring text i s))
	       (let ((v (assq (string-ref text (+ s 1)) keylist)))
		 (if v
		     (write-string port (cdr v))
		     (write-string port (substring text s e)))
		 (loop e)))
	     (write-string port (substring text i))))))))

(define (expanded-file-content (fs <file-space>) 
			       (p <fs-absolute-path>)
			       (v <file-version>)
			       (global-keys <list>))
  (if (instance? (contents v) <text-file-content>)
      (expand-keys 
       (content->string (contents v))
       (cons* (cons #\I (version-tag->string
			 (version-tag v)))
	      (cons #\E (time->string (modification-time v) "%Y.%m.%d"))
	      (cons #\p (substring (fs-path->string p) 1))
	      (cons #\U (time->string (modification-time v) "%H:%M:%S"))
	      global-keys))
      (content->string (contents v))))
