/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: rproxy.h,v 1.23 2000/08/16 10:08:58 mbp Exp $
 * 
 * Copyright (C) 1999, 2000 by Martin Pool <mbp@linuxcare.com.au>
 * Copyright (C) 1999 tridge@samba.org
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#define BUFFER_SIZE 512
#define MIN_CACHE_SIZE 2048

#define PTR_DIFF(p1,p2) ((ptrdiff_t)(((const char *)(p1)) - (const char *)(p2)))


struct config {
    int             serve_one, dont_fork;
    char           *upstream_host;
    int             upstream_port;

    /* This is not set for inetd.  See also req->local_port */
    int             listen_port;
    int             no_cache:1, remove_sig:1;
    char const     *transfer_logfile;
    FILE           *transfer_log;
    char const     *cache_root;
    char const     *stderr_file;
    char           *my_hostname;
    char           *out_sockopts;
    int             stats_log_fd;

    /* If we're using syslog, then this is the name of the facility to
     * use.  Otherwise, use stderr. */
    int             use_syslog;
    char           *syslog_facility;
};


/* TODO: Don't include there here, do it directly in the source file.*/
#include "http.h"
#include "request.h"


/* ========================================

   messages to the client */
void            msg_error(request_t * req, int code, char const *msg);


extern struct config config;

#define PROGRAM "rproxy"

#define DEFAULT_HTTP_PORT 80


/* =================================================================
 * HTTP stuff
 * ================================================================= */

int             read_response_status_line(request_t * req);
int             read_request_line(request_t * req);

int             will_do_version(request_t const *req);

bool_t          req_can_send_client_error_p(request_t * req);

void            set_request_status(request_t * req, int code,
                                   char const *str);


/* Maximum size of signature to use.  This will become an efficiency tuning
   parameter -- see the tradeoff discussion in the documentation. */
#define RS_MAX_SIG_SIZE 512

struct sockaddr;
int             rp_serve(int read_fd, int write_fd, struct sockaddr *addr);


/* send a requst to the upstream proxy then return a FILE pointer for the
   upstream socket */
FILE           *send_upstream(request_t *);

#define HSYNC_ENCODING_TOKEN "hsync"



/* ========================================

   hsync encoding/decoding */
size_t
choose_block_size(size_t cached_size);

int
decode_hsync_request(request_t * req);
int
will_encode_hsync(request_t const *req);
int
encode_hsync_request(request_t * req);
int
add_old_sig_header(request_t * req);

/***********************************************************************
 * IO
 ***********************************************************************/
size_t
stream_body(FILE * f_in, FILE * f_out, FILE * f_copy, int content_length);


#define SIGNATURE_HEADER "Rsync-Signature"


void rp_setup_syslog(void);
