/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: pass.c,v 1.1 2000/08/16 10:08:58 mbp Exp $
 * 
 * Copyright (C) 2000 by Martin Pool <mbp@humbug.org.au>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "sysheaders.h"

#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "rproxy.h"

#include "util.h"
#include "urllib.h"
#include "header.h"
#include "myname.h"
#include "trace.h"
#include "logfile.h"
#include "error.h"
#include "pass.h"

/*
 * Pass through request.
 *
 * We never cache passthrough requests: if they're encoded and we're
 * not decoding then we won't be able to separate out the signature
 * and body for later use.  If the response is not encoded, then we
 * won't have a signature and so can't use it for future requests.
 *
 * This can be a really good thing anyhow: it's pretty unlikely that
 * we'll decode a request the second time if we didn't do it the first
 * time, so there's no point wasting disk space on the possibility.
 */
void
rp_pass_through(request_t * req)
{
    int             stream_size;

    /* case 1 and 2, send as-is */
    req->action_str = "pass";
    rp_process_name("%s %s", req->action_str, req->url);
    trace(LOGAREA_PROTO, "pass request through unchanged");

    req->state = sending_response_headers;
    rp_send_response_line(req);

    if (header_send(req->headers, req->f_to_client) < 0)
	return;

    /* Stream the body across, but don't bother if for some reason there is
       no body. */
    if (req->content_length != 0) {
	req->state = sending_body;
	stream_size = stream_body(req->f_upstream, req->f_to_client,
				  NULL, req->content_length);
    }

    fflush(req->f_to_client);
}


