/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: msgpage.c,v 1.10 2000/08/14 02:26:42 mbp Exp $
 * 
 * Copyright (C) 1999, 2000 by Martin Pool <mbp@linuxcare.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

                                        /*
                                         | I waited and waited and
                                         | when no message came I knew
                                         | it must be from you.
                                         */

/*
 * TODO: Internationalize the messages visible to the end user through
 * this file, to suit their Accept-Language header.  We'll also need
 * to set some headers for Language (?) and character set.  Probably
 * it's OK just to hardcode the messages since there are so few.
 * Shall we use locales to get the right system error messages?
 */


#include "config.h"
#include "sysheaders.h"

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "rproxy.h"
#include "msgpage.h"
#include "util.h"
#include "urllib.h"
#include "request.h"
#include "statusline.h"

static void
msg_html_header(FILE * f_to_client, char const *title)
{
    fprintf(f_to_client,
	    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n"
	    "<html><head><title>%s</title></head><body>\n"
	    "<h1>%s</h1>\n", title, title);
}


static void
msg_html_footer(FILE * f_to_client)
{
    fprintf(f_to_client,
	    "<p><hr><a href=\"http://www.linuxcare.com.au/rproxy/\">"
	    PROGRAM " " VERSION "</a></body></html>\n");
}



void
msg_error(request_t * req, int code, char const *msg)
{
    time_t          now;
    
    /* FIXME: We ought to make sure to send message headers, unless
     * they've already been sent.  In fact, if they have been sent
     * there's probably nothing we can do -- there's no point sending
     * an error message in the middle of some other resource. */
    assert(req && req->f_to_client);
    assert(code >= 100 && code <= 599);
    rp_req_set_status(req, HTTP_BAD_GATEWAY);
    rp_send_response_line(req);

    fprintf(req->f_to_client,
	    "Content-Type: text/html\r\n" "Connection: close\r\n" "\r\n");

    msg_html_header(req->f_to_client, "rproxy error");
    fprintf(req->f_to_client, "<p>An error occurred ");

    if (req->req_line) {
	fprintf(req->f_to_client, "while requesting:\n"
		"<p><blockquote><tt>%s</tt></blockquote>\n", req->req_line);
    }

    fprintf(req->f_to_client, "<p>HTTP error code: %d %s\n", code,
            http_status_string(code));

    time(&now);
    fprintf(req->f_to_client,
	    "<p><blockquote>%s</blockquote>\n"
	    "<p><em>rproxy[%d] on %s:%d (%s)\n"
            "<p>%s</em>\n",
	    msg,
            (int) getpid(),
            config.my_hostname, req->local_port,
            config.serve_one ? "inetd" : "daemon",
            asctime(gmtime((&now))));

    msg_html_footer(req->f_to_client);
}
