
/* Thieved from Xaw by C Cannam 1995, in order to sustain a gross hack */
/* I apologise to all Athena programmers and to anyone else whose life */
/* may be made meaningless by the sheer enormity of this crime         */

/*
 * $XConsortium: YSmeBSBP.h,v 1.6 89/12/11 15:20:15 kit Exp $
 *
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Chris D. Peterson, MIT X Consortium
 */

#ifndef _XawYSmeBSBP_h
#define _XawYSmeBSBP_h

/***********************************************************************
 *
 * YSmeBSB Object Private Data
 *
 ***********************************************************************/

#include <X11/Xaw/SmeP.h>
#include <YSmeBSB.h>

/************************************************************
 *
 * New fields for the YSmeBSB Object class record.
 *
 ************************************************************/

typedef struct _YSmeBSBClassPart {
  XtPointer extension;
} YSmeBSBClassPart;

/* Full class record declaration */
typedef struct _YSmeBSBClassRec {
    RectObjClassPart       rect_class;
    SmeClassPart     sme_class;
    YSmeBSBClassPart  sme_bsb_class;
} YSmeBSBClassRec;

extern YSmeBSBClassRec ysmeBSBClassRec;

/* New fields for the YSmeBSB Object record */
typedef struct {
    /* resources */
    String label;		/* The entry label. */
    int vert_space;		/* extra vert space to leave, as a percentage
				   of the font height of the label. */
    Pixmap left_bitmap, right_bitmap; /* bitmaps to show. */
    Dimension left_margin, right_margin; /* left and right margins. */
    Pixel foreground;		/* foreground color. */
    XFontStruct * font;		/* The font to show label in. */
    XtJustify justify;		/* Justification for the label. */

/* private resources. */

    Boolean set_values_area_cleared; /* Remember if we need to unhighlight. */
    GC norm_gc;			/* noral color gc. */
    GC rev_gc;			/* reverse color gc. */
    GC norm_gray_gc;		/* Normal color (grayed out) gc. */
    GC invert_gc;		/* gc for flipping colors. */

    Dimension left_bitmap_width; /* size of each bitmap. */
    Dimension left_bitmap_height;
    Dimension right_bitmap_width;
    Dimension right_bitmap_height;

} YSmeBSBPart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _YSmeBSBRec {
  ObjectPart         object;
  RectObjPart        rectangle;
  SmePart	     sme;
  YSmeBSBPart   sme_bsb;
} YSmeBSBRec;

/************************************************************
 *
 * Private declarations.
 *
 ************************************************************/

#endif /* _XawYSmeBSBP_h */
