#ifndef TREE_BUILDER_XML_H
#define TREE_BUILDER_XML_H

#include <iostream>
using namespace std;

#include "common.h"
#include "tree_builder.h"
#include "path.h"

class TreeBuilderXml : public TreeBuilder
{
public:
        virtual void load_file(const string& filename);

        static TreeBuilderXml *instance() {
                if (!instance_) {
                        rpdbgmsg("Creating TreeBuilderXml");
                        instance_ = new TreeBuilderXml();
                }
                return instance_;
        }

        static void destroy_instance() {
                if (instance_) {
                        rpdbgmsg("Destroying TreeBuilderXml");
                        delete instance_;
                        instance_ = 0;
                }
        }               
                        
private:
        static TreeBuilderXml *instance_;
};

#endif
