#include <cctype>
using namespace std;

#include "networkload.h"
#include "../../module_registry.h"

DataSetMap *Networkload::moduleInfo = 0;

#define FILENAME "/proc/net/dev"

Module* networkload_constructor()
{
        return new Networkload();
}

const DataSetMap& Networkload::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Monitors network usage"));
                moduleInfo->set("supported_vars", DataSet("device_name"));
                moduleInfo->set("supported_var_types", DataSet("string"));
                moduleInfo->set("supported_var_defaults", DataSet("ppp0"));
                moduleInfo->set("overridable", DataSet("false"));
                moduleInfo->set("output_variables", DataSet("receive,transmit,total"));
        }
        return *moduleInfo;
}

extern "C" int networkload_plugin_startup()
{
        ModuleRegistry::instance()->add_module("Networkload", &networkload_constructor, Networkload::get_module_info_instance());
        return 0;
}

extern "C" void networkload_plugin_shutdown()
{
        ModuleRegistry::instance()->remove_module("Modifier");
        Networkload::destroy_module_info();
}

Networkload::Networkload()
        : loopCount(0)
{
        file = fopen(FILENAME, "rb");
}

Networkload::~Networkload()
{
        if (file != NULL) {
                if (verbose)
                        cout << "closing: \"" << FILENAME << "\"" << endl;
                fclose(file);
        }
        rpdbgmsg(getName() << " module destroyed");
}

void Networkload::updated(const string& keyName, const DataSet& data)
{
        if (keyName == "device_name") {
                deviceName = data.getString();
                lastReceive = "";
        }
}

string Networkload::getLine()
{
        string text;
        for (;;) {
                int tmp = fgetc(file);
                if (tmp <= 0 || tmp == 10 || tmp == 13 || tmp > 255)
                        break;
                text += char(tmp);
        }
        return text;
}

int Networkload::stringDifference(const string& lastString, const string& newString)
{
        int i = 0, j =0;
        while (lastString[i] == ' ')
                i++;
        while (lastString[j] == ' ')
                j++;
        while (i < lastString.length()
               && j < newString.length()
               && lastString[i] == newString[i]) {
                i++;
                j++;
        }
        string a(lastString, i, lastString.length() - i);
        string b(newString, j, newString.length() - j);

        return atoi(b.c_str()) - atoi(a.c_str());
}

void Networkload::service()
{
        Module::service();

        loopCount++;
        if (loopCount > 30) {
                file = freopen(FILENAME, "rb", file);
                fseek(file, 0, SEEK_SET);

                getLine();
                getLine();
                
                string dev;
                string line;
                string receiveString, transmitString;
                int i;
                do {
                        dev = "";
                        line = getLine();
                        i = 0;

                        // skip any spaces
                        while (i < line.length() && line[i] == ' ')
                                i++;

                        // scan the device name
                        while (i < line.length()) {
                                if (line[i] == ':')
                                        break;
                                else
                                        dev += line[i];
                                i++;
                        }

                } while (line.length() > 0 && dev != deviceName);

                i++;

                while (i < line.length() && line[i] == ' ')
                        i++;
                
                // scan the bytes received
                while (i < line.length() && isdigit(line[i])) {
                        receiveString += line[i];
                        i++;
                }

                // skip the next 7 numbers
                for (int j = 0; j < 7; j++) {
                        while (i < line.length() && line[i] == ' ')
                                i++;
                                
                        while (i < line.length() && isdigit(line[i]))
                                i++;
                }

                while (i < line.length() && line[i] == ' ')
                        i++;
                
                // scan the bytes transmitted
                while (i < line.length() && isdigit(line[i])) {
                        transmitString += line[i];
                        i++;
                }

                if (line.length() > 0) {
                        if (lastReceive.length() != 0) {
                                int receive = stringDifference(lastReceive, receiveString);
                                int transmit = stringDifference(lastTransmit, transmitString);
                                addToOutput("receive", DataSet(receive));
                                addToOutput("transmit", DataSet(transmit));
                                addToOutput("total", DataSet(receive + transmit));
                                sendOutput();
                        }
                        lastReceive = receiveString;
                        lastTransmit = transmitString;
                }
                loopCount = 0;
        }
}
