/*

ChangeLog

* Sat Dec 09 2000 Sourav K. Mandal <Sourav.Mandal@ikaran.com>
- "Consoledump" module.  Captures messages from /dev/console and
  forwards them to parent module, sort of like xconsole.
- See corresponding ".cpp" file for implementation details.

*/

#ifndef CONSOLEDUMP_H
#define CONSOLEDUMP_H

using namespace std;

#include "../../module.h"

class ConsoleDump : public Module {
  public:
    ConsoleDump();
    ~ConsoleDump();
	  void service();
    virtual string getName() {
       return "Consoledump";
    }
    virtual const DataSetMap& get_module_info() {
      return get_module_info_instance();
    }
    static const DataSetMap &get_module_info_instance();
    static void destroy_module_info() {
      if (moduleInfo)
        delete moduleInfo;
        moduleInfo = 0;
    }                
  
  private:
    static DataSetMap* moduleInfo;
                        
  protected:
     void updated(const string& keyName, const DataSet& data);

  private:
    fd_set rdfs;
    char *buf;
    int console ;
    int slave ;
    void errnomsg(const char *);

};

#endif
