#ifndef MODULE_H
#define MODULE_H

#include "datasetmap.h"
#include "path.h"

#include <vector>
#include <string>
#include <map>
using namespace std;

class Module {
public:
        Module() : parentModule(0), output(new DataSetMap()) {}
	virtual ~Module();

        virtual const DataSetMap& get_module_info() = 0;
        
        const DataSetMap& getEnv() const {return env;}
        void set(const string& keyName, const DataSet& newValue) {
                update(keyName, newValue);
                updated(keyName, newValue);
        }
        void setDefaults();
        
        /* must call parent */
	virtual void service();

        /* called after environment has been set and modules have been created */
        virtual void postStartup();
        
        /* called before modules start getting destroyed */
        virtual void preShutdown();

        typedef vector<Module*>::iterator iterator;
        iterator begin() {return childModules.begin();}
        iterator end() {return childModules.end();}

        typedef vector<Module*>::const_iterator const_iterator;
        const_iterator begin() const {return childModules.begin();}
        const_iterator end() const {return childModules.end();}

        virtual string getName() = 0;

        virtual Module* newChild(const string& typeName);
        void delChild(Module* m);

        Module* getParent() {return parentModule;}
        
        string issue_command(const Path& path, const string& command,
                                     const string& parameter);
        virtual string send_on_command(const Path& path, const string& command,
                                       const string& parameter);
        virtual string execute_command(const string& command_name, const string& parameter);
        virtual void return_message(const DataSet& msg, Path path = Path());
        
	void setParent(Module* parent) {
	    	parentModule = parent;
	}

        int child_num(Module *ch);
        
protected:
        string default_execute_command(const string& command_name, const string& parameter);
	virtual void updated(const string& keyName, const DataSet& newValue) {}
        
	void update(const string& keyName, const DataSet& data) {
		env.set(keyName, data);
	}
	void updateParent(const string& keyName, const DataSet& data);

        /* like updateParent, except that everything is accumulated in a DataSetMap
         * then output as a single message when sendOutput is called */
        void addToOutput(const string& keyName, const DataSet& data) {
                output->set(keyName, data);
        }
        void sendOutput();
        void clearOutput() {
                delete output;
                output = new DataSetMap();                
        }
        void receiveOutput(const DataSetMap& rOutput);
        virtual void outputReceived(const DataSetMap& rOutput);

        void addChild(Module* child) {childModules.push_back(child);}

	DataSetMap env;
	Module* parentModule;
	vector<Module*> childModules;
        
private:
        void addStickyToOutput();        
        DataSetMap* output;
};

#endif
