#ifndef DRAWING_AREA_REGISTRY_H
#define DRAWING_AREA_REGISTRY_H

class DrawingArea;

#include <X11/Xlib.h>

#include <vector>
using namespace std;

class DrawingAreaRegistry
{
public:
        void register_da(DrawingArea *da);
        
        void unregister_da(DrawingArea *da);

        static DrawingAreaRegistry *instance() {
                if (instancep == 0)
                        instancep = new DrawingAreaRegistry();
                return instancep;
        }

        static void destroy_instance() {
                if (instancep != NULL) {
                        delete instancep;
                        instancep = 0;
                }
        }

        void exposed(XExposeEvent *ex);
                
private:
        vector<DrawingArea *> das;
        static DrawingAreaRegistry *instancep;
        
        DrawingAreaRegistry() {} // prohibit creation (except by us)        
};

#endif
