/* This module is based on roottail by Mike Baker <mbm@linux.com>
 */

#ifndef ROOTTEXT_H
#define ROOTTEXT_H

#include "../../common.h"
#include "../../module.h"
#include "../../rootwindow.h"
#include "../../drawing_area.h"
#include <vector>
using namespace std;

typedef unsigned long Pixel;

class Roottext : public Module, public DrawingArea
{
public:
        Roottext();
        ~Roottext();
        void service();

        virtual string getName() {
                return "Roottext";
        }
                        
        virtual const DataSetMap& get_module_info() {
                return get_module_info_instance();
        }
        static const DataSetMap &get_module_info_instance();

        static void destroy_module_info() {
                if (moduleInfo)
                        delete moduleInfo;
                moduleInfo = 0;
        }                
private:
        static DataSetMap* moduleInfo;
                        
protected:
        void updated(const string& keyName, const DataSet& data);
        void geometry_updated();
private:
        void display();
        void redraw(XExposeEvent *ev);
        void insert(const string& textline, int start, int size);
        Pixel getColour(const string& ColourName);

        Display* disp;
        XFontStruct *fontinfo;

        int spacing, displayallow;
        Font font;
        Pixel colour, bgcolour;
        bool draw_background;

        bool timed_redraw;
        int timed_redraw_skip;
        int cycle;

        vector<string> lines;
        vector<Pixel> lineColours;
        vector<Pixel> bgColours;

        /* disallow assignment */
        Roottext& operator=(const Roottext& other) {}

        /* disallow copy */
        Roottext(const Roottext& other) {}
};

#endif
